/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.finance.statement.AbstractStatementTest;
import org.openvpms.archetype.rules.finance.statement.EndOfPeriodProcessor;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;

public class StatementRulesTestCase
extends AbstractStatementTest {
    @Autowired
    private LaboratoryRules laboratoryRules;
    private StatementRules rules;

    @Before
    public void setUp() {
        this.rules = new StatementRules(this.getPractice(), this.getArchetypeService(), this.getRules());
    }

    @Test
    public void testGetStatementPreview() {
        Party customer = this.getCustomer();
        BigDecimal feeAmount = new BigDecimal("25.00");
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(feeAmount, AccountType.FeeType.FIXED).accountFeeDays(30).accountFeeBalance(0).accountFeeMessage("Test Accounting Fee").build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        List<FinancialAct> invoices1 = this.createChargesInvoice(BigDecimal.TEN, this.getDatetime("2017-12-31 10:00:00"));
        this.save(invoices1);
        FinancialAct openingBalance = this.getRules().createOpeningBalance(customer, this.getDate("2018-01-01"), BigDecimal.TEN);
        this.save((IMObject)openingBalance);
        List<FinancialAct> invoices2 = this.createChargesInvoice(MathRules.ONE_HUNDRED, this.getDatetime("2018-01-01 10:00:00"));
        FinancialAct invoice2 = invoices2.get(0);
        this.save(invoices2);
        List<FinancialAct> invoices3 = this.createChargesInvoice(MathRules.ONE_HUNDRED, this.getDatetime("2018-01-01 10:30:00"));
        FinancialAct invoice3 = invoices3.get(0);
        invoice3.setStatus("COMPLETED");
        this.save(invoices3);
        List<FinancialAct> invoices4 = this.createChargesInvoice(BigDecimal.TEN, this.getDatetime("2018-01-01 11:00:00"));
        FinancialAct invoice4 = invoices4.get(0);
        invoice4.setStatus("IN_PROGRESS");
        this.save(invoices4);
        List<FinancialAct> invoices5 = this.createChargesInvoice(BigDecimal.TEN, this.getDatetime("2018-01-03 11:00:00"));
        FinancialAct invoice5 = invoices5.get(0);
        invoice5.setStatus("POSTED");
        this.save(invoices5);
        this.checkStatementPreview(customer, this.getDate("2018-01-01"), this.getDate("2018-01-02"), openingBalance, invoice2, invoice3);
        this.checkStatementPreview(customer, this.getDate("2018-01-02"), openingBalance, invoice2, invoice3);
        List<FinancialAct> acts1 = this.getStatementPreview(customer, this.getDate("2018-01-01"), this.getDate("2018-02-05"));
        Assert.assertEquals((long)5L, (long)acts1.size());
        this.checkActs(acts1.subList(0, 4), openingBalance, invoice2, invoice3, invoice5);
        this.checkFee(acts1.get(4), feeAmount);
        List<FinancialAct> acts2 = this.getStatementPreview(customer, this.getDate("2018-02-05"), true, true);
        Assert.assertEquals((long)5L, (long)acts2.size());
        this.checkActs(acts2.subList(0, 4), openingBalance, invoice2, invoice3, invoice5);
        this.checkFee(acts2.get(4), feeAmount);
        List<FinancialAct> acts3 = this.getStatementPreview(customer, this.getDate("2018-02-05"), false, false);
        this.checkActs(acts3, openingBalance, invoice2, invoice5);
    }

    @Test
    public void testGetStatement() {
        Party customer = this.getCustomer();
        BigDecimal amount = new BigDecimal(950);
        List<FinancialAct> invoices1 = this.createChargesInvoice(amount, this.getDatetime("2017-12-29 10:00:00"));
        FinancialAct invoice1 = invoices1.get(0);
        this.save(invoices1);
        Date statementDate1 = this.getDate("2017-12-31");
        this.runEndOfPeriod(customer, statementDate1);
        this.checkEquals(amount, this.accountRules.getBalance(customer));
        this.checkStatement(customer, statementDate1, invoice1);
        this.checkStatementRange(customer, this.getDate("2017-12-01"), this.getDate("2017-12-31"), BigDecimal.ZERO, invoice1);
        this.checkStatementRange(customer, this.getDate("2018-01-01"), this.getDate("2018-01-31"), amount, new FinancialAct[0]);
        FinancialAct payment1 = this.createPayment(amount, this.getDatetime("2018-01-14 14:52:00"));
        this.save((IMObject)payment1);
        FinancialAct opening1 = this.accountRules.getOpeningBalanceAfter(customer, statementDate1);
        Assert.assertNotNull((Object)opening1);
        this.checkEquals(amount, opening1.getTotal());
        Assert.assertFalse((boolean)opening1.isCredit());
        Date statementDate3 = this.getDate("2018-01-01");
        this.checkStatement(customer, opening1.getActivityStartTime(), statementDate3, opening1);
        this.checkStatement(customer, statementDate3, opening1);
        Date statementDate4 = this.getDate("2018-01-14");
        this.checkStatement(customer, opening1.getActivityStartTime(), statementDate4, opening1, payment1);
        this.checkStatement(customer, statementDate4, opening1, payment1);
        Date statementDate5 = this.getDate("2018-01-31");
        this.runEndOfPeriod(customer, statementDate5);
        FinancialAct opening2 = this.accountRules.getOpeningBalanceAfter(customer, statementDate5);
        Assert.assertNotNull((Object)opening2);
        this.checkEquals(BigDecimal.ZERO, opening2.getTotal());
        Date statementDate6 = this.getDate("2018-02-01");
        this.checkStatement(customer, statementDate6, opening2);
        this.checkStatement(customer, statementDate4, opening1, payment1);
        this.checkStatement(customer, opening1.getActivityStartTime(), statementDate4, opening1, payment1);
        this.checkStatementRange(customer, null, null, invoice1, payment1);
        this.checkStatementRange(customer, this.getDate("2017-12-31"), null, amount, payment1);
        this.checkStatementRange(customer, this.getDate("2017-12-31"), this.getDate("2018-01-05"), amount, new FinancialAct[0]);
        this.checkStatementRange(customer, this.getDate("2017-12-31"), this.getDate("2018-01-15"), amount, payment1);
    }

    @Test
    public void testGetStatementRange() {
        Party customer = this.getCustomer();
        BigDecimal amount = BigDecimal.TEN;
        FinancialAct payment1 = this.createPayment(amount, this.getDate("2021-10-30"));
        this.save((IMObject)payment1);
        Date statementDate1 = this.getDate("2021-10-31");
        this.runEndOfPeriod(customer, statementDate1);
        this.checkEquals(amount.negate(), this.accountRules.getBalance(customer));
        FinancialAct opening1 = this.accountRules.getOpeningBalanceAfter(customer, statementDate1);
        Assert.assertNotNull((Object)opening1);
        this.checkEquals(amount, opening1.getTotal());
        Assert.assertTrue((boolean)opening1.isCredit());
        List<FinancialAct> invoice1 = this.createChargesInvoice(new BigDecimal("160"), this.getDate("2021-11-01"));
        this.save(invoice1);
        Date statementDate2 = this.getDate("2021-11-30");
        this.runEndOfPeriod(customer, statementDate2);
        FinancialAct payment2 = this.createPayment(new BigDecimal("150"), this.getDate("2021-12-01"));
        this.save((IMObject)payment2);
        this.checkStatementRange(customer, this.getDate("2021-11-30"), this.getDate("2021-12-31"), new BigDecimal("150"), payment2);
        this.checkStatementRange(customer, this.getDate("2021-12-01"), this.getDate("2021-12-31"), new BigDecimal("150"), payment2);
        this.checkStatementRange(customer, this.getDate("2021-12-02"), this.getDate("2021-12-31"), BigDecimal.ZERO, new FinancialAct[0]);
    }

    private void runEndOfPeriod(Party customer, Date statementDate) {
        EndOfPeriodProcessor eop = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), (IArchetypeRuleService)this.getArchetypeService(), this.accountRules, this.laboratoryRules);
        eop.process(customer);
    }

    private void checkFee(FinancialAct fee, BigDecimal feeAmount) {
        this.checkDebitAdjust((Act)fee, feeAmount, "Test Accounting Fee");
        Assert.assertTrue((boolean)fee.isNew());
    }

    private void checkStatementPreview(Party customer, Date from, Date to, FinancialAct ... expected) {
        List<FinancialAct> actual = this.getStatementPreview(customer, from, to);
        this.checkActs(actual, expected);
    }

    private List<FinancialAct> getStatementPreview(Party customer, Date from, Date to) {
        return IteratorUtils.toList(this.rules.getStatementPreview(customer, from, to, true, true).iterator());
    }

    private void checkStatementPreview(Party customer, Date date, FinancialAct ... expected) {
        List<FinancialAct> actual = this.getStatementPreview(customer, date, true, true);
        this.checkActs(actual, expected);
    }

    private List<FinancialAct> getStatementPreview(Party customer, Date date, boolean includeCompletedCharges, boolean includeFee) {
        Iterable preview = this.rules.getStatementPreview(customer, date, includeCompletedCharges, includeFee);
        return IteratorUtils.toList(preview.iterator());
    }

    private List<FinancialAct> getStatement(Party customer, Date date) {
        return IteratorUtils.toList(this.rules.getStatement(customer, date).iterator());
    }

    private void checkStatement(Party customer, Date date, FinancialAct ... expected) {
        List<FinancialAct> actual = this.getStatement(customer, date);
        this.checkActs(actual, expected);
    }

    private void checkStatement(Party customer, Date from, Date to, FinancialAct ... expected) {
        List actual = IteratorUtils.toList(this.rules.getStatement(customer, from, to).iterator());
        this.checkActs(actual, expected);
    }

    private void checkStatementRange(Party customer, Date from, Date to, FinancialAct ... expected) {
        List actual = IteratorUtils.toList(this.rules.getStatementRange(customer, from, to).iterator());
        this.checkActs(actual, expected);
    }

    private void checkStatementRange(Party customer, Date from, Date to, BigDecimal balance, FinancialAct ... expected) {
        List actual = IteratorUtils.toList(this.rules.getStatementRange(customer, from, to).iterator());
        Assert.assertEquals((long)(expected.length + 1), (long)actual.size());
        FinancialAct opening = (FinancialAct)actual.remove(0);
        Assert.assertEquals((Object)from, (Object)opening.getActivityStartTime());
        this.checkEquals(balance, opening.getTotal());
        this.checkActs(actual, expected);
    }

    private void checkActs(List<FinancialAct> actual, FinancialAct ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual.get(i));
        }
    }
}

