/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.estimate;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ValidationError;
import org.springframework.beans.factory.annotation.Autowired;

public class EstimateActTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestProductFactory productFactory;

    @Test
    public void testDelete() {
        Act item = (Act)this.accountFactory.newEstimateItem().patient(this.patientFactory.createPatient()).product(this.productFactory.createMerchandise()).build(false);
        Act estimate = (Act)this.accountFactory.newEstimate().customer(this.customerFactory.createCustomer()).add(item).build();
        Assert.assertNotNull((Object)this.get(estimate));
        Assert.assertNotNull((Object)this.get(item));
        this.remove((IMObject)estimate);
        Assert.assertNull((Object)this.get(estimate));
        Assert.assertNull((Object)this.get(item));
    }

    @Test
    public void testLowHighQuantity() {
        Party patient = this.patientFactory.createPatient();
        Product product = this.productFactory.createMerchandise();
        Act item1 = (Act)this.accountFactory.newEstimateItem().patient(patient).product(product).lowQuantity(1).highQuantity(0).build(false);
        try {
            this.getArchetypeService().validateObject((IMObject)item1);
            Assert.fail((String)"Expected ValidationException");
        }
        catch (ValidationException expected) {
            List errors = expected.getErrors();
            Assert.assertEquals((long)1L, (long)errors.size());
            Assert.assertEquals((Object)"The High Qty must be >= the Low Qty", (Object)((ValidationError)errors.get(0)).getMessage());
        }
        Act item2 = (Act)this.accountFactory.newEstimateItem().patient(patient).product(product).lowQuantity(0).highQuantity(0).build(false);
        this.getArchetypeService().validateObject((IMObject)item2);
        Act item3 = (Act)this.accountFactory.newEstimateItem().patient(patient).product(product).lowQuantity(0).highQuantity(1).build(false);
        this.getArchetypeService().validateObject((IMObject)item3);
    }
}

