/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.AbstractCustomerAccountTest;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceGenerator;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceUpdater;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class CustomerBalanceGeneratorTestCase
extends AbstractCustomerAccountTest {
    @Autowired
    private CustomerBalanceUpdater updater;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private IArchetypeService service;

    @Before
    public void setUp() {
        this.service = (IArchetypeService)this.applicationContext.getBean("archetypeService", IArchetypeService.class);
    }

    @Test
    public void testGenerateBalanceForChargesInvoiceAndPayment() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        List<FinancialAct> payment = Collections.singletonList(this.createPayment(amount));
        this.checkCalculateBalanceForSameAmount(invoice, payment);
    }

    @Test
    public void testGetBalanceForChargesCounterAndPayment() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> counter = this.createChargesCounter(amount);
        List<FinancialAct> payment = Collections.singletonList(this.createPayment(amount));
        this.checkCalculateBalanceForSameAmount(counter, payment);
    }

    @Test
    public void testGetBalanceForChargesInvoiceAndCredit() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        List<FinancialAct> credit = this.createChargesCredit(amount);
        this.checkCalculateBalanceForSameAmount(invoice, credit);
    }

    @Test
    public void testGetBalanceForNegativeChargesInvoiceAndCredit() {
        BigDecimal amount = new BigDecimal(-100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        List<FinancialAct> credit = this.createChargesCredit(amount);
        this.checkCalculateBalanceForSameAmount(invoice, credit);
    }

    @Test
    public void testGetBalanceForRefundAndPayment() {
        BigDecimal amount = new BigDecimal(100);
        FinancialAct refund = this.createRefund(amount);
        FinancialAct payment = this.createCreditAdjust(amount);
        this.checkCalculateBalanceForSameAmount(refund, payment);
    }

    @Test
    public void testGetBalanceForDebitAndCreditAdjust() {
        BigDecimal amount = new BigDecimal(100);
        FinancialAct debit = this.createDebitAdjust(amount);
        FinancialAct credit = this.createCreditAdjust(amount);
        this.checkCalculateBalanceForSameAmount(debit, credit);
    }

    @Test
    public void testGetBalanceForInitialBalanceAndBadDebt() {
        BigDecimal amount = new BigDecimal(100);
        FinancialAct debit = this.createInitialBalance(amount);
        FinancialAct credit = this.createBadDebt(amount);
        this.checkCalculateBalanceForSameAmount(debit, credit);
    }

    @Test
    public void testAddParticipationForNonPostedActs() {
        List<FinancialAct> invoice1 = this.createChargesInvoice(new BigDecimal(100));
        this.checkAddParticipationForNonPostedAct(invoice1, "IN_PROGRESS");
        List<FinancialAct> invoice2 = this.createChargesInvoice(new BigDecimal(100));
        this.checkAddParticipationForNonPostedAct(invoice2, "ON_HOLD");
        List<FinancialAct> invoice3 = this.createChargesInvoice(new BigDecimal(100));
        this.checkAddParticipationForNonPostedAct(invoice3, "COMPLETED");
    }

    @Test
    public void testChangeOpeningAndClosingBalances() {
        Party customer = this.getCustomer();
        List<FinancialAct> invoice = this.createChargesInvoice(new BigDecimal(10));
        FinancialAct opening1 = this.createOpeningBalance(customer);
        FinancialAct payment = this.createPayment(new BigDecimal(30));
        FinancialAct closing1 = this.createClosingBalance(customer);
        FinancialAct opening2 = this.createOpeningBalance(customer);
        this.service.save(invoice);
        this.service.save(Arrays.asList(opening1, payment, closing1, opening2));
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        try {
            this.accountRules.getDefinitiveBalance(customer);
            Assert.fail((String)"Expected getDefinitiveBalance() to fail");
        }
        catch (CustomerAccountRuleException expected) {
            Assert.assertEquals((Object)CustomerAccountRuleException.ErrorCode.InvalidBalance, (Object)expected.getErrorCode());
        }
        this.checkEquals(new BigDecimal(-20), this.generate(customer));
        this.checkEquals(new BigDecimal(-20), this.accountRules.getBalance(customer));
        opening1 = this.get(opening1);
        closing1 = this.get(closing1);
        opening2 = this.get(opening2);
        this.checkEquals(new BigDecimal(10), opening1.getTotal());
        Assert.assertFalse((boolean)opening1.isCredit());
        this.checkEquals(new BigDecimal(20), closing1.getTotal());
        Assert.assertFalse((boolean)closing1.isCredit());
        this.checkEquals(new BigDecimal(20), opening2.getTotal());
        Assert.assertTrue((boolean)opening2.isCredit());
    }

    private void checkCalculateBalanceForSameAmount(FinancialAct debit, FinancialAct credit) {
        this.checkCalculateBalanceForSameAmount(Collections.singletonList(debit), Collections.singletonList(credit));
    }

    private void checkCalculateBalanceForSameAmount(List<FinancialAct> debits, List<FinancialAct> credits) {
        Party customer = this.getCustomer();
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        Assert.assertTrue((boolean)this.checkBalance(customer));
        this.service.save(debits);
        Assert.assertFalse((boolean)this.checkBalance(customer));
        FinancialAct debit = debits.get(0);
        this.checkEquals(debit.getTotal(), this.generate(customer));
        this.checkEquals(debit.getTotal(), this.accountRules.getBalance(customer));
        Assert.assertTrue((boolean)this.checkBalance(customer));
        debit = this.get(debit);
        Participation balanceParticipation1 = this.getAccountBalanceParticipation(debit);
        Assert.assertNotNull((Object)balanceParticipation1);
        this.checkEquals(debit.getTotal(), this.generate(customer));
        debit = this.get(debit);
        Participation balanceParticipation2 = this.getAccountBalanceParticipation(debit);
        Assert.assertNotNull((Object)balanceParticipation2);
        Assert.assertNotEquals((Object)balanceParticipation1, (Object)balanceParticipation2);
        this.service.save(credits);
        this.checkEquals(BigDecimal.ZERO, this.generate(customer));
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        debit = this.get(debit);
        FinancialAct credit = (FinancialAct)this.get((IMObject)credits.get(0));
        ActRelationship debitAlloc = this.getAccountAllocationRelationship(debit);
        ActRelationship creditAlloc = this.getAccountAllocationRelationship(credit);
        if (debit.getTotal().signum() != -1) {
            this.checkAllocation(debitAlloc, debit, credit, debit.getTotal());
            this.checkAllocation(creditAlloc, debit, credit, debit.getTotal());
        } else {
            BigDecimal total = debit.getTotal().abs();
            this.checkAllocation(debitAlloc, credit, debit, total);
            this.checkAllocation(creditAlloc, credit, debit, total);
        }
        Assert.assertTrue((boolean)this.checkBalance(customer));
        this.service.remove((IMObject)credit);
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        this.checkEquals(debit.getTotal(), this.generate(customer));
        this.checkEquals(debit.getTotal().abs(), debit.getAllocatedAmount());
        debit = this.get(debit);
        this.checkEquals(BigDecimal.ZERO, debit.getAllocatedAmount());
        this.checkEquals(debit.getTotal(), this.accountRules.getBalance(customer));
        Assert.assertTrue((boolean)this.checkBalance(customer));
        Participation balanceParticipation3 = this.getAccountBalanceParticipation(debit);
        Assert.assertNotNull((Object)balanceParticipation3);
        Assert.assertNotEquals((Object)balanceParticipation3, (Object)balanceParticipation2);
        Assert.assertNull((Object)this.getAccountAllocationRelationship(debit));
    }

    private boolean checkBalance(Party customer) {
        BigDecimal actual;
        BalanceCalculator calc = new BalanceCalculator(this.getArchetypeService());
        BigDecimal expected = calc.getDefinitiveBalance(customer);
        return expected.compareTo(actual = calc.getBalance(customer)) == 0;
    }

    private void checkAllocation(ActRelationship relationship, FinancialAct source, FinancialAct target, BigDecimal allocated) {
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)relationship.getSource(), (Object)source.getObjectReference());
        Assert.assertEquals((Object)relationship.getTarget(), (Object)target.getObjectReference());
        IMObjectBean bean = this.getBean((IMObject)relationship);
        this.checkEquals(allocated, bean.getBigDecimal("allocatedAmount"));
    }

    private void checkAddParticipationForNonPostedAct(List<FinancialAct> acts, String status) {
        Assert.assertNotEquals((Object)"POSTED", (Object)status);
        Party customer = this.getCustomer();
        FinancialAct act = acts.get(0);
        act.setStatus(status);
        this.service.save(acts);
        this.checkEquals(BigDecimal.ZERO, this.generate(customer));
        act = this.get(act);
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)customer, (Object)bean.getTarget("accountBalance"));
        Assert.assertNull((Object)this.getAccountAllocationRelationship(act));
        this.checkEquals(BigDecimal.ZERO, act.getAllocatedAmount());
    }

    private BigDecimal generate(Party customer) {
        CustomerBalanceGenerator generator = new CustomerBalanceGenerator(customer, this.getArchetypeService(), this.updater, this.transactionManager);
        return generator.generate();
    }

    private Participation getAccountBalanceParticipation(FinancialAct act) {
        IMObjectBean bean = this.getBean((IMObject)act);
        return (Participation)bean.getObject("accountBalance", Participation.class);
    }

    private ActRelationship getAccountAllocationRelationship(FinancialAct act) {
        IMObjectBean bean = this.getBean((IMObject)act);
        return (ActRelationship)bean.getObject("allocation", ActRelationship.class);
    }

    private FinancialAct createOpeningBalance(Party customer) {
        FinancialAct act = this.create("act.customerAccountOpeningBalance", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("customer", (IMObject)customer);
        return act;
    }

    private FinancialAct createClosingBalance(Party customer) {
        FinancialAct act = this.create("act.customerAccountClosingBalance", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("customer", (IMObject)customer);
        return act;
    }
}

