/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n.time;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.i18n.time.CompositeDurationFormatter;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.i18n.time.DurationFormatter;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;

public class CompositeDurationFormatterTestCase {
    @Test
    public void testFormat() {
        CompositeDurationFormatter formatter = new CompositeDurationFormatter();
        formatter.add(7, DateUnits.DAYS, (DurationFormatter)new DateDurationFormatter(false, false, false, true));
        formatter.add(90, DateUnits.DAYS, (DurationFormatter)new DateDurationFormatter(false, false, true, false));
        formatter.add(1, DateUnits.YEARS, (DurationFormatter)new DateDurationFormatter(false, true, false, false));
        formatter.add(2, DateUnits.YEARS, (DurationFormatter)new DateDurationFormatter(true, true, false, false));
        Date from = TestHelper.getDate("2011-01-01");
        Date to1 = TestHelper.getDate("2011-01-07");
        Date to2 = TestHelper.getDate("2011-01-08");
        Date to3 = TestHelper.getDate("2011-01-09");
        Date to4 = TestHelper.getDate("2012-01-01");
        Date to5 = TestHelper.getDate("2013-02-01");
        this.checkFormat("6 Days", from, to1, (DurationFormatter)formatter);
        this.checkFormat("7 Days", from, to2, (DurationFormatter)formatter);
        this.checkFormat("1 Week", from, to3, (DurationFormatter)formatter);
        this.checkFormat("12 Months", from, to4, (DurationFormatter)formatter);
        this.checkFormat("2 Years 1 Month", from, to5, (DurationFormatter)formatter);
    }

    @Test
    public void testDefault() {
        CompositeDurationFormatter formatter = new CompositeDurationFormatter();
        Date from = TestHelper.getDate("2008-01-01");
        Date to1 = TestHelper.getDate("2008-12-31");
        Date to2 = TestHelper.getDate("2009-01-01");
        Date to3 = TestHelper.getDate("2011-05-01");
        this.checkFormat("0 Years", from, to1, (DurationFormatter)formatter);
        this.checkFormat("1 Year", from, to2, (DurationFormatter)formatter);
        this.checkFormat("3 Years", from, to3, (DurationFormatter)formatter);
    }

    @Test
    public void testDefaultOverride() {
        DateDurationFormatter override = new DateDurationFormatter(false, false, false, true);
        CompositeDurationFormatter formatter = new CompositeDurationFormatter();
        formatter.setDefaultFormatter((DurationFormatter)override);
        Date from = TestHelper.getDate("2008-01-01");
        Date to1 = TestHelper.getDate("2008-12-31");
        Date to2 = TestHelper.getDate("2009-01-01");
        Date to3 = TestHelper.getDate("2011-05-01");
        this.checkFormat("365 Days", from, to1, (DurationFormatter)formatter);
        this.checkFormat("366 Days", from, to2, (DurationFormatter)formatter);
        this.checkFormat("1216 Days", from, to3, (DurationFormatter)formatter);
    }

    private void checkFormat(String expected, Date from, Date to, DurationFormatter formatter) {
        String result = formatter.format(from, to);
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

