/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.reminder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.function.reminder.ReminderFunctions;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderFunctionsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PracticeService practiceService;

    @Test
    public void testGetRemindersByCustomer() {
        Party customer = TestHelper.createCustomer();
        this.checkGetReminders(customer, customer);
    }

    @Test
    public void testGetRemindersByCustomerForInactivePatientRelationship() {
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient(customer);
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder = ReminderTestHelper.createReminderWithDueDate(patient, reminderType, DateRules.getTomorrow());
        JXPathContext ctx = this.createContext(customer);
        List reminders1 = (List)ctx.getValue("reminder:getReminders(., 1, 'YEARS')");
        Assert.assertEquals((long)1L, (long)reminders1.size());
        Assert.assertEquals((Object)reminder, reminders1.get(0));
        IMObjectBean bean = this.getBean((IMObject)customer);
        List owner = bean.getValues("patients", EntityRelationship.class);
        Assert.assertEquals((long)1L, (long)owner.size());
        ((EntityRelationship)owner.get(0)).setActiveEndTime(new Date());
        this.save((IMObject[])new Party[]{customer, patient});
        List reminders2 = (List)ctx.getValue("reminder:getReminders(., 1, 'YEARS')");
        Assert.assertEquals((long)0L, (long)reminders2.size());
    }

    @Test
    public void testGetRemindersByCustomerExcludesInactivePatient() {
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient(customer);
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder = ReminderTestHelper.createReminderWithDueDate(patient, reminderType, DateRules.getTomorrow());
        JXPathContext ctx = this.createContext(customer);
        List reminders1 = (List)ctx.getValue("reminder:getReminders(., 1, 'YEARS')");
        Assert.assertEquals((long)1L, (long)reminders1.size());
        Assert.assertEquals((Object)reminder, reminders1.get(0));
        patient.setActive(false);
        this.save((IMObject)patient);
        List reminders2 = (List)ctx.getValue("reminder:getReminders(., 1, 'YEARS')");
        Assert.assertEquals((long)0L, (long)reminders2.size());
    }

    @Test
    public void testGetRemindersByCustomerExcludesDeceasedPatient() {
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient(customer);
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder = ReminderTestHelper.createReminderWithDueDate(patient, reminderType, DateRules.getTomorrow());
        JXPathContext ctx = this.createContext(customer);
        List reminders1 = (List)ctx.getValue("reminder:getReminders(., 1, 'YEARS')");
        Assert.assertEquals((long)1L, (long)reminders1.size());
        Assert.assertEquals((Object)reminder, reminders1.get(0));
        IMObjectBean bean = this.getBean((IMObject)patient);
        bean.setValue("deceased", (Object)true);
        bean.save();
        List reminders2 = (List)ctx.getValue("reminder:getReminders(., 1, 'YEARS')");
        Assert.assertEquals((long)0L, (long)reminders2.size());
    }

    @Test
    public void testGetRemindersByAct() {
        Act act = this.create("act.customerAccountChargesInvoice", Act.class);
        Party customer = TestHelper.createCustomer();
        IMObjectBean invoice = this.getBean((IMObject)act);
        invoice.setTarget("customer", (IMObject)customer);
        this.checkGetReminders(act, customer);
    }

    @Test
    public void testGetDocumentFormReminder() {
        Party patient = TestHelper.createPatient();
        DocumentAct form = this.create("act.patientDocumentForm", DocumentAct.class);
        IMObjectBean formBean = this.getBean((IMObject)form);
        formBean.setTarget("patient", (IMObject)patient);
        this.save((IMObject)form);
        Assert.assertNull((Object)this.getDocumentFormReminder(form));
        FinancialAct item = FinancialTestHelper.createChargeItem("act.customerAccountInvoiceItem", patient, TestHelper.createProduct(), BigDecimal.ONE);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        itemBean.addTarget("documents", (IMObject)form, "invoiceItem");
        this.save((IMObject[])new Act[]{item, form});
        Act reminder = ReminderTestHelper.createReminder(patient, ReminderTestHelper.createReminderType(new Lookup[0]));
        itemBean.addTarget("reminders", (IMObject)reminder, "invoiceItem");
        this.save((IMObject[])new Act[]{item, reminder});
        Assert.assertEquals((Object)reminder, (Object)this.getDocumentFormReminder(form));
    }

    @Test
    public void testGetPatientRemindersForDate() {
        Party patient = TestHelper.createPatient();
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder1 = this.createReminder(patient, reminderType, "2016-04-13 11:59:59", "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient, reminderType, "2016-04-14 10:10:10", "IN_PROGRESS");
        Act reminder3 = this.createReminder(patient, reminderType, "2016-04-14 10:10:10", "COMPLETED");
        Act reminder4 = this.createReminder(patient, reminderType, "2016-04-14 10:10:10", "CANCELLED");
        Act reminder5 = this.createReminder(patient, reminderType, "2016-04-15 00:00:00", "IN_PROGRESS");
        JXPathContext context = this.createContext(patient);
        List<Act> acts = this.getActs((Iterable)context.getValue("reminder:getReminders(., java.sql.Timestamp.valueOf('2016-04-14 11:00:00'))"));
        Assert.assertEquals((long)3L, (long)acts.size());
        Assert.assertFalse((boolean)acts.contains(reminder1));
        Assert.assertTrue((boolean)acts.contains(reminder2));
        Assert.assertTrue((boolean)acts.contains(reminder3));
        Assert.assertTrue((boolean)acts.contains(reminder4));
        Assert.assertFalse((boolean)acts.contains(reminder5));
    }

    @Test
    public void testGetPatientRemindersForDateRange() {
        Party patient = TestHelper.createPatient();
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder1 = this.createReminder(patient, reminderType, "2016-04-13 11:59:59", "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient, reminderType, "2016-04-14 10:10:10", "IN_PROGRESS");
        Act reminder3 = this.createReminder(patient, reminderType, "2016-04-14 11:10:10", "COMPLETED");
        Act reminder4 = this.createReminder(patient, reminderType, "2016-04-15 10:10:10", "CANCELLED");
        Act reminder5 = this.createReminder(patient, reminderType, "2016-04-15 11:00:00", "IN_PROGRESS");
        JXPathContext context = this.createContext(patient);
        List<Act> acts = this.getActs((Iterable)context.getValue("reminder:getReminders(., java.sql.Timestamp.valueOf('2016-04-14 10:00:00'), java.sql.Timestamp.valueOf('2016-04-15 11:00:00'))"));
        Assert.assertEquals((long)3L, (long)acts.size());
        Assert.assertFalse((boolean)acts.contains(reminder1));
        Assert.assertTrue((boolean)acts.contains(reminder2));
        Assert.assertTrue((boolean)acts.contains(reminder3));
        Assert.assertTrue((boolean)acts.contains(reminder4));
        Assert.assertFalse((boolean)acts.contains(reminder5));
    }

    @Test
    public void testGetPatientRemindersByProductType() {
        Party patient = TestHelper.createPatient();
        Entity productType1 = ProductTestHelper.createProductType("Z Vaccination 1");
        Entity productType2 = ProductTestHelper.createProductType("Z Vaccination 2");
        Product product1 = ProductTestHelper.createMedication(productType1);
        Product product2 = ProductTestHelper.createMedication(productType2);
        Product product3 = TestHelper.createProduct();
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder1 = this.createReminder(patient, reminderType, product1, "2016-04-13 11:59:59", "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient, reminderType, product2, "2016-04-14 10:10:10", "IN_PROGRESS");
        Act reminder3 = this.createReminder(patient, reminderType, product1, "2016-04-14 11:10:10", "COMPLETED");
        Act reminder4 = this.createReminder(patient, reminderType, product3, "2016-04-15 10:10:10", "CANCELLED");
        Act reminder5 = this.createReminder(patient, reminderType, product1, "2016-04-15 11:00:00", "IN_PROGRESS");
        JXPathContext context = this.createContext(patient);
        List<Act> acts1 = this.getActs((Iterable)context.getValue("reminder:getReminders(., 'Z Vaccination 1', java.sql.Timestamp.valueOf('2016-04-14 11:00:00'))"));
        Assert.assertEquals((long)1L, (long)acts1.size());
        Assert.assertFalse((boolean)acts1.contains(reminder1));
        Assert.assertFalse((boolean)acts1.contains(reminder2));
        Assert.assertTrue((boolean)acts1.contains(reminder3));
        Assert.assertFalse((boolean)acts1.contains(reminder4));
        Assert.assertFalse((boolean)acts1.contains(reminder5));
        List<Act> acts2 = this.getActs((Iterable)context.getValue("reminder:getReminders(.,  'Z Vaccination*', java.sql.Timestamp.valueOf('2016-04-14 11:00:00'))"));
        Assert.assertEquals((long)2L, (long)acts2.size());
        Assert.assertTrue((boolean)acts2.contains(reminder2));
        Assert.assertTrue((boolean)acts2.contains(reminder3));
    }

    @Test
    public void testGetPatientRemindersByProductTypeForDateRange() {
        Party patient = TestHelper.createPatient();
        Entity productType1 = ProductTestHelper.createProductType("Z Vaccination 1");
        Entity productType2 = ProductTestHelper.createProductType("Z Vaccination 2");
        Product product1 = ProductTestHelper.createMedication(productType1);
        Product product2 = ProductTestHelper.createMedication(productType2);
        Product product3 = TestHelper.createProduct();
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Act reminder1 = this.createReminder(patient, reminderType, product1, "2016-04-13 11:59:59", "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient, reminderType, product2, "2016-04-14 10:10:10", "IN_PROGRESS");
        Act reminder3 = this.createReminder(patient, reminderType, product1, "2016-04-14 11:10:10", "COMPLETED");
        Act reminder4 = this.createReminder(patient, reminderType, product2, "2016-04-15 10:10:10", "CANCELLED");
        Act reminder5 = this.createReminder(patient, reminderType, product3, "2016-04-15 10:45:00", "IN_PROGRESS");
        Act reminder6 = this.createReminder(patient, reminderType, product1, "2016-04-15 11:00:00", "IN_PROGRESS");
        JXPathContext context = this.createContext(patient);
        List<Act> acts1 = this.getActs((Iterable)context.getValue("reminder:getReminders(., 'Z Vaccination 1', java.sql.Timestamp.valueOf('2016-04-14 10:00:00'), java.sql.Timestamp.valueOf('2016-04-15 11:00:00'))"));
        Assert.assertEquals((long)1L, (long)acts1.size());
        Assert.assertFalse((boolean)acts1.contains(reminder1));
        Assert.assertFalse((boolean)acts1.contains(reminder2));
        Assert.assertTrue((boolean)acts1.contains(reminder3));
        Assert.assertFalse((boolean)acts1.contains(reminder4));
        Assert.assertFalse((boolean)acts1.contains(reminder5));
        Assert.assertFalse((boolean)acts1.contains(reminder6));
        List<Act> acts2 = this.getActs((Iterable)context.getValue("reminder:getReminders(., 'Z Vacc*', java.sql.Timestamp.valueOf('2016-04-14 10:00:00'), java.sql.Timestamp.valueOf('2016-04-15 11:00:00'))"));
        Assert.assertEquals((long)3L, (long)acts2.size());
        Assert.assertFalse((boolean)acts2.contains(reminder1));
        Assert.assertTrue((boolean)acts2.contains(reminder2));
        Assert.assertTrue((boolean)acts2.contains(reminder3));
        Assert.assertTrue((boolean)acts2.contains(reminder4));
        Assert.assertFalse((boolean)acts2.contains(reminder5));
        Assert.assertFalse((boolean)acts2.contains(reminder6));
    }

    private List<Act> getActs(Iterable<Act> acts) {
        ArrayList<Act> result = new ArrayList<Act>();
        CollectionUtils.addAll(result, acts);
        return result;
    }

    private void checkGetReminders(Object context, Party customer) {
        int count = 10;
        Entity reminderType = ReminderTestHelper.createReminderType(new Lookup[0]);
        Date date = DateRules.getDate((Date)new Date(), (int)-5, (DateUnits)DateUnits.DAYS);
        for (int i = 0; i < 10; ++i) {
            Date dueDate = DateRules.getDate((Date)date, (int)(i + 1), (DateUnits)DateUnits.DAYS);
            Party patient = TestHelper.createPatient(customer);
            ReminderTestHelper.createReminderWithDueDate(patient, reminderType, dueDate);
        }
        JXPathContext ctx = this.createContext(context);
        List reminders1 = (List)ctx.getValue("reminder:getReminders(., 1, 'YEARS')");
        Assert.assertEquals((long)6L, (long)reminders1.size());
        List reminders2 = (List)ctx.getValue("reminder:getReminders(., 12, 'MONTHS', 'true')");
        Assert.assertEquals((long)10L, (long)reminders2.size());
    }

    private Act createReminder(Party patient, Entity reminderType, String startTime, String status) {
        Act reminder = ReminderTestHelper.createReminder(patient, reminderType, TestHelper.getDatetime(startTime));
        reminder.setStatus(status);
        this.save((IMObject)reminder);
        return reminder;
    }

    private Act createReminder(Party patient, Entity reminderType, Product product, String startTime, String status) {
        Act reminder = ReminderTestHelper.createReminder(patient, reminderType, TestHelper.getDatetime(startTime));
        IMObjectBean bean = this.getBean((IMObject)reminder);
        bean.setTarget("product", (IMObject)product);
        reminder.setStatus(status);
        this.save((IMObject)reminder);
        return reminder;
    }

    private Act getDocumentFormReminder(Object context) {
        JXPathContext ctx = this.createContext(context);
        return (Act)ctx.getValue("reminder:getDocumentFormReminder(.)");
    }

    private JXPathContext createContext(Object context) {
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        PatientRules patientRules = new PatientRules(null, this.practiceService, service, lookups);
        ReminderFunctions functions = new ReminderFunctions(service, new ReminderRules(service, patientRules), new CustomerRules(service, lookups, null));
        return JXPathHelper.newContext((Object)context, (Functions)functions);
    }
}

