/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.history;

import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.history.HistoryFunctions;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.ArchetypeServiceFunctions;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;

public class HistoryFunctionsTestCase
extends ArchetypeServiceTest {
    private Party patient;

    @Before
    public void setUp() {
        this.patient = TestHelper.createPatient();
    }

    @Test
    public void testCharges() {
        FinancialAct item1 = this.createInvoiceItem();
        FinancialAct item2 = this.createInvoiceItem();
        item1.setActivityStartTime(TestHelper.getDate("2016-05-02"));
        item2.setActivityStartTime(TestHelper.getDate("2016-05-03"));
        this.save((IMObject[])new Act[]{item1, item2});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts = (Iterable)ctx.getValue("history:charges(.)");
        this.checkActs(acts, new Act[]{item2, item1});
    }

    @Test
    public void testChargesByDate() {
        FinancialAct item1 = this.createInvoiceItem();
        FinancialAct item2 = this.createInvoiceItem();
        FinancialAct item3 = this.createInvoiceItem();
        item1.setActivityStartTime(TestHelper.getDatetime("2016-05-03 00:00:00"));
        item2.setActivityStartTime(TestHelper.getDatetime("2016-05-03 23:59:00"));
        item3.setActivityStartTime(TestHelper.getDate("2016-05-04"));
        this.save((IMObject[])new Act[]{item1, item2, item3});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:charges(., null)");
        this.checkActs(acts1, new Act[0]);
        Iterable acts2 = (Iterable)ctx.getValue("history:charges(., java.sql.Date.valueOf('2016-05-03'))");
        this.checkActs(acts2, new Act[]{item2, item1});
        Iterable acts3 = (Iterable)ctx.getValue("history:charges(., java.sql.Date.valueOf('2016-05-04'))");
        this.checkActs(acts3, new Act[]{item3});
        Iterable acts4 = (Iterable)ctx.getValue("history:charges(., java.sql.Date.valueOf('2016-05-05'))");
        this.checkActs(acts4, new Act[0]);
    }

    @Test
    public void testChargesByDateRange() {
        FinancialAct item1 = this.createInvoiceItem();
        FinancialAct item2 = this.createInvoiceItem();
        item1.setActivityStartTime(TestHelper.getDate("2016-05-03"));
        item2.setActivityStartTime(TestHelper.getDate("2016-05-04"));
        this.save((IMObject[])new Act[]{item1, item2});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:charges(., null, null)");
        this.checkActs(acts1, new Act[]{item2, item1});
        Iterable acts2 = (Iterable)ctx.getValue("history:charges(., java.sql.Date.valueOf('2016-05-03'), java.sql.Date.valueOf('2016-05-05'))");
        this.checkActs(acts2, new Act[]{item2, item1});
        Iterable acts3 = (Iterable)ctx.getValue("history:charges(., java.sql.Date.valueOf('2016-05-03'), java.sql.Date.valueOf('2016-05-04'))");
        this.checkActs(acts3, new Act[]{item1});
        Iterable acts4 = (Iterable)ctx.getValue("history:charges(., null, java.sql.Date.valueOf('2016-05-04'))");
        this.checkActs(acts4, new Act[]{item1});
        Iterable acts5 = (Iterable)ctx.getValue("history:charges(., null, java.sql.Date.valueOf('2016-05-05'))");
        this.checkActs(acts5, new Act[]{item2, item1});
        Iterable acts6 = (Iterable)ctx.getValue("history:charges(., java.sql.Date.valueOf('2016-05-03'), null)");
        this.checkActs(acts6, new Act[]{item2, item1});
    }

    @Test
    public void testChargesByProductType() {
        Entity productType1 = this.createProductType("Vaccination");
        Entity productType2 = this.createProductType("Euthanasia");
        Product product1 = this.createProduct(productType1);
        Product product2 = this.createProduct(productType2);
        FinancialAct item1 = this.createInvoiceItem(product1);
        FinancialAct item2 = this.createInvoiceItem(product2);
        this.save((IMObject[])new Act[]{item1, item2});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:charges(., 'Vaccination')");
        this.checkActs(acts1, new Act[]{item1});
        Iterable acts2 = (Iterable)ctx.getValue("history:charges(., 'Euth*')");
        this.checkActs(acts2, new Act[]{item2});
        Iterable acts3 = (Iterable)ctx.getValue("history:charges(., 'Procedure')");
        this.checkActs(acts3, new Act[0]);
    }

    @Test
    public void testChargesByProductTypeAndDate() {
        Entity productType1 = this.createProductType("Vaccination");
        Entity productType2 = this.createProductType("Euthanasia");
        Product product1 = this.createProduct(productType1);
        Product product2 = this.createProduct(productType2);
        FinancialAct item1 = this.createInvoiceItem(product1);
        FinancialAct item2 = this.createInvoiceItem(product1);
        FinancialAct item3 = this.createInvoiceItem(product2);
        item1.setActivityStartTime(TestHelper.getDatetime("2016-05-03 00:00:00"));
        item2.setActivityStartTime(TestHelper.getDatetime("2016-05-03 23:59:00"));
        item3.setActivityStartTime(TestHelper.getDate("2016-05-04"));
        this.save((IMObject[])new Act[]{item1, item2, item3});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:charges(., 'Vaccination', null)");
        this.checkActs(acts1, new Act[0]);
        Iterable acts2 = (Iterable)ctx.getValue("history:charges(., 'Vacc*', java.sql.Date.valueOf('2016-05-03'))");
        this.checkActs(acts2, new Act[]{item2, item1});
        Iterable acts3 = (Iterable)ctx.getValue("history:charges(., 'Vaccination', java.sql.Date.valueOf('2016-05-04'))");
        this.checkActs(acts3, new Act[0]);
    }

    @Test
    public void testChargesByProductTypeAndDateRange() {
        Entity productType1 = this.createProductType("Vaccination");
        Entity productType2 = this.createProductType("Euthanasia");
        Product product1 = this.createProduct(productType1);
        Product product2 = this.createProduct(productType2);
        FinancialAct item1 = this.createInvoiceItem(product1);
        FinancialAct item2 = this.createInvoiceItem(product2);
        item1.setActivityStartTime(TestHelper.getDate("2016-05-03"));
        item2.setActivityStartTime(TestHelper.getDate("2016-05-04"));
        this.save((IMObject[])new Act[]{item1, item2});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:charges(., 'Vaccination', null, null)");
        this.checkActs(acts1, new Act[]{item1});
        Iterable acts2 = (Iterable)ctx.getValue("history:charges(., 'Vacc*', java.sql.Date.valueOf('2016-05-03'), java.sql.Date.valueOf('2016-05-04'))");
        this.checkActs(acts2, new Act[]{item1});
        Iterable acts3 = (Iterable)ctx.getValue("history:charges(., 'Vaccination', java.sql.Date.valueOf('2016-05-01'), java.sql.Date.valueOf('2016-05-03'))");
        this.checkActs(acts3, new Act[0]);
    }

    @Test
    public void testChargesWithNullPatient() {
        Act event = this.create("act.patientClinicalEvent", Act.class);
        JXPathContext ctx = this.createContext((IMObject)event);
        Iterable acts1 = (Iterable)ctx.getValue("history:charges(openvpms:get(., 'patient.entity'))");
        this.checkActs(acts1, new Act[0]);
        Iterable acts2 = (Iterable)ctx.getValue("history:charges(openvpms:get(., 'patient.entity'), null, null)");
        this.checkActs(acts2, new Act[0]);
        Iterable acts3 = (Iterable)ctx.getValue("history:charges(openvpms:get(., 'patient.entity'), 'Vaccination')");
        this.checkActs(acts3, new Act[0]);
        Iterable acts4 = (Iterable)ctx.getValue("history:charges(openvpms:get(., 'patient.entity'), 'Vaccination', null, null)");
        this.checkActs(acts4, new Act[0]);
    }

    @Test
    public void testMedication() {
        Act medication1 = PatientTestHelper.createMedication(this.patient);
        Act medication2 = PatientTestHelper.createMedication(this.patient);
        medication1.setActivityStartTime(TestHelper.getDate("2013-09-19"));
        medication2.setActivityStartTime(TestHelper.getDate("2013-09-20"));
        this.save((IMObject[])new Act[]{medication1, medication2});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts = (Iterable)ctx.getValue("history:medication(.)");
        this.checkActs(acts, medication2, medication1);
    }

    @Test
    public void testMedicationByDate() {
        Act medication1 = PatientTestHelper.createMedication(this.patient);
        Act medication2 = PatientTestHelper.createMedication(this.patient);
        Act medication3 = PatientTestHelper.createMedication(this.patient);
        medication1.setActivityStartTime(TestHelper.getDatetime("2013-09-19 00:00:00"));
        medication2.setActivityStartTime(TestHelper.getDatetime("2013-09-19 23:59:00"));
        medication3.setActivityStartTime(TestHelper.getDate("2013-09-20"));
        this.save((IMObject[])new Act[]{medication1, medication2, medication3});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:medication(., null)");
        this.checkActs(acts1, new Act[0]);
        Iterable acts2 = (Iterable)ctx.getValue("history:medication(., java.sql.Date.valueOf('2013-09-19'))");
        this.checkActs(acts2, medication2, medication1);
        Iterable acts3 = (Iterable)ctx.getValue("history:medication(., java.sql.Date.valueOf('2013-09-20'))");
        this.checkActs(acts3, medication3);
        Iterable acts4 = (Iterable)ctx.getValue("history:medication(., java.sql.Date.valueOf('2013-09-21'))");
        this.checkActs(acts4, new Act[0]);
    }

    @Test
    public void testMedicationByDateRange() {
        Act medication1 = PatientTestHelper.createMedication(this.patient);
        Act medication2 = PatientTestHelper.createMedication(this.patient);
        medication1.setActivityStartTime(TestHelper.getDate("2013-09-19"));
        medication2.setActivityStartTime(TestHelper.getDate("2013-09-20"));
        this.save((IMObject[])new Act[]{medication1, medication2});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:medication(., null, null)");
        this.checkActs(acts1, medication2, medication1);
        Iterable acts2 = (Iterable)ctx.getValue("history:medication(., java.sql.Date.valueOf('2013-09-19'), java.sql.Date.valueOf('2013-09-21'))");
        this.checkActs(acts2, medication2, medication1);
        Iterable acts3 = (Iterable)ctx.getValue("history:medication(., java.sql.Date.valueOf('2013-09-19'), java.sql.Date.valueOf('2013-09-20'))");
        this.checkActs(acts3, medication1);
        Iterable acts4 = (Iterable)ctx.getValue("history:medication(., null, java.sql.Date.valueOf('2013-09-20'))");
        this.checkActs(acts4, medication1);
        Iterable acts5 = (Iterable)ctx.getValue("history:medication(., null, java.sql.Date.valueOf('2013-09-21'))");
        this.checkActs(acts5, medication2, medication1);
        Iterable acts6 = (Iterable)ctx.getValue("history:medication(., java.sql.Date.valueOf('2013-09-19'), null)");
        this.checkActs(acts6, medication2, medication1);
    }

    @Test
    public void testMedicationByProductType() {
        Entity productType1 = this.createProductType("Vaccination");
        Entity productType2 = this.createProductType("Euthanasia");
        Product product1 = this.createProduct(productType1);
        Product product2 = this.createProduct(productType2);
        Act medication1 = PatientTestHelper.createMedication(this.patient, product1);
        Act medication2 = PatientTestHelper.createMedication(this.patient, product2);
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:medication(., 'Vaccination')");
        this.checkActs(acts1, medication1);
        Iterable acts2 = (Iterable)ctx.getValue("history:medication(., 'Euth*')");
        this.checkActs(acts2, medication2);
        Iterable acts3 = (Iterable)ctx.getValue("history:medication(., 'Procedure')");
        this.checkActs(acts3, new Act[0]);
    }

    @Test
    public void testMedicationByProductTypeAndDate() {
        Entity productType1 = this.createProductType("Vaccination");
        Entity productType2 = this.createProductType("Euthanasia");
        Product product1 = this.createProduct(productType1);
        Product product2 = this.createProduct(productType2);
        Act medication1 = PatientTestHelper.createMedication(this.patient, product1);
        Act medication2 = PatientTestHelper.createMedication(this.patient, product1);
        Act medication3 = PatientTestHelper.createMedication(this.patient, product2);
        medication1.setActivityStartTime(TestHelper.getDatetime("2013-09-19 00:00:00"));
        medication2.setActivityStartTime(TestHelper.getDatetime("2013-09-19 23:59:00"));
        medication3.setActivityStartTime(TestHelper.getDate("2013-09-20"));
        this.save((IMObject[])new Act[]{medication1, medication2, medication3});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:medication(., 'Vaccination', null)");
        this.checkActs(acts1, new Act[0]);
        Iterable acts2 = (Iterable)ctx.getValue("history:medication(., 'Vacc*', java.sql.Date.valueOf('2013-09-19'))");
        this.checkActs(acts2, medication2, medication1);
        Iterable acts3 = (Iterable)ctx.getValue("history:medication(., 'Vaccination', java.sql.Date.valueOf('2013-09-20'))");
        this.checkActs(acts3, new Act[0]);
    }

    @Test
    public void testMedicationByProductTypeAndDateRange() {
        Entity productType1 = this.createProductType("Vaccination");
        Entity productType2 = this.createProductType("Euthanasia");
        Product product1 = this.createProduct(productType1);
        Product product2 = this.createProduct(productType2);
        Act medication1 = PatientTestHelper.createMedication(this.patient, product1);
        Act medication2 = PatientTestHelper.createMedication(this.patient, product2);
        medication1.setActivityStartTime(TestHelper.getDate("2013-09-19"));
        medication2.setActivityStartTime(TestHelper.getDate("2013-09-20"));
        this.save((IMObject[])new Act[]{medication1, medication2});
        JXPathContext ctx = this.createContext((IMObject)this.patient);
        Iterable acts1 = (Iterable)ctx.getValue("history:medication(., 'Vaccination', null, null)");
        this.checkActs(acts1, medication1);
        Iterable acts2 = (Iterable)ctx.getValue("history:medication(., 'Vacc*', java.sql.Date.valueOf('2013-09-19'), java.sql.Date.valueOf('2013-09-20'))");
        this.checkActs(acts2, medication1);
        Iterable acts3 = (Iterable)ctx.getValue("history:medication(., 'Vaccination', java.sql.Date.valueOf('2013-09-01'), java.sql.Date.valueOf('2013-09-18'))");
        this.checkActs(acts3, new Act[0]);
    }

    @Test
    public void testMedicationWithNullPatient() {
        Act event = this.create("act.patientClinicalEvent", Act.class);
        JXPathContext ctx = this.createContext((IMObject)event);
        Iterable acts1 = (Iterable)ctx.getValue("history:medication(openvpms:get(., 'patient.entity'))");
        this.checkActs(acts1, new Act[0]);
        Iterable acts2 = (Iterable)ctx.getValue("history:medication(openvpms:get(., 'patient.entity'), null, null)");
        this.checkActs(acts2, new Act[0]);
        Iterable acts3 = (Iterable)ctx.getValue("history:medication(openvpms:get(., 'patient.entity'), 'Vaccination')");
        this.checkActs(acts3, new Act[0]);
        Iterable acts4 = (Iterable)ctx.getValue("history:medication(openvpms:get(., 'patient.entity'), 'Vaccination', null, null)");
        this.checkActs(acts4, new Act[0]);
    }

    protected FinancialAct createInvoiceItem() {
        return FinancialTestHelper.createChargeItem("act.customerAccountInvoiceItem", this.patient, TestHelper.createProduct(), BigDecimal.ONE);
    }

    protected FinancialAct createInvoiceItem(Product product) {
        return FinancialTestHelper.createChargeItem("act.customerAccountInvoiceItem", this.patient, product, BigDecimal.ONE);
    }

    private void checkActs(Iterable<Act> acts, Act ... expected) {
        Assert.assertNotNull(acts);
        Iterator<Act> iterator = acts.iterator();
        for (Act act : expected) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)act, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private Product createProduct(Entity productType) {
        return ProductTestHelper.createMedication(productType);
    }

    private Entity createProductType(String name) {
        return ProductTestHelper.createProductType(name);
    }

    private JXPathContext createContext(IMObject object) {
        HistoryFunctions history = new HistoryFunctions(this.getArchetypeService());
        ArchetypeServiceFunctions functions = new ArchetypeServiceFunctions(this.getArchetypeService(), this.getLookupService());
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)history);
        library.addFunctions((Functions)new ObjectFunctions((Object)functions, "openvpms"));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

