/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.eftpos;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.hibernate.validator.internal.util.Contracts;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.function.eftpos.EFTPOSFunctions;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;
import org.springframework.beans.factory.annotation.Autowired;

public class EFTPOSFunctionsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testPrintableReceipts() {
        Party customer = this.customerFactory.createCustomer();
        Entity terminal = (Entity)this.practiceFactory.newEFTPOSTerminal().printer(false).build();
        FinancialAct transaction1 = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(customer)).amount(BigDecimal.TEN)).terminal(terminal)).location(this.practiceFactory.createLocation())).addMerchantReceipt("MERCHANT 1", true)).addCustomerReceipt("CUSTOMER 1")).status("DECLINED")).build();
        FinancialAct transaction2 = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(customer)).amount(BigDecimal.TEN)).terminal(terminal)).location(this.practiceFactory.createLocation())).addMerchantReceipt("MERCHANT 2", true)).addCustomerReceipt("CUSTOMER 2")).status("APPROVED")).build();
        FinancialAct item1 = (FinancialAct)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().amount(BigDecimal.TEN)).addTransaction(transaction1)).addTransaction(transaction2)).build(false);
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).till(this.practiceFactory.createTill())).add(item1)).status("POSTED")).build();
        this.addParentId(transaction1, (Act)payment);
        this.addParentId(transaction2, (Act)payment);
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new ObjectFunctions((Object)new EFTPOSFunctions((ArchetypeService)this.getArchetypeService()), "eftpos"));
        JXPathContext context = JXPathHelper.newContext((Object)payment, (Functions)library);
        Iterable receipt1 = (Iterable)context.getValue("eftpos:printableReceipts()");
        this.checkReceipts(receipt1, "CUSTOMER 1", "CUSTOMER 2");
        Iterable receipt2 = (Iterable)context.getValue("eftpos:printableReceipts(.)");
        this.checkReceipts(receipt2, "CUSTOMER 1", "CUSTOMER 2");
        IMObjectBean bean = this.getBean((IMObject)terminal);
        bean.setValue("printer", (Object)true);
        bean.save();
        Iterable receipt3 = (Iterable)context.getValue("eftpos:printableReceipts()");
        this.checkReceipts(receipt3, new String[0]);
    }

    private void addParentId(FinancialAct transaction, Act parent) {
        ActIdentity identity = this.create("actIdentity.EFTPOSParentId", ActIdentity.class);
        identity.setIdentity(Long.toString(parent.getId()));
        transaction.addIdentity(identity);
        this.save((IMObject)transaction);
    }

    private void checkReceipts(Iterable<DocumentAct> receipts, String ... expected) {
        Contracts.assertNotNull(receipts);
        List actual = IteratorUtils.toList(receipts.iterator());
        Assert.assertEquals((long)expected.length, (long)actual.size());
        List<String> list = Arrays.asList(expected);
        for (DocumentAct act : actual) {
            IMObjectBean bean = this.getBean((IMObject)act);
            String receipt = bean.getString("receipt");
            Contracts.assertNotNull((Object)receipt);
            Assert.assertTrue((boolean)list.contains(receipt));
        }
    }
}

