/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.contact;

import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.function.contact.EmailFunctions;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailFunctionsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestContactFactory contactFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private CustomerRules customerRules;

    @Test
    public void testGetContacts() {
        Contact emailA = this.contactFactory.createEmail("a@foo.com", "BILLING");
        Contact emailB = this.contactFactory.createEmail("b@foo.com", "CORRESPONDENCE");
        Contact emailC = this.contactFactory.createEmail("c@foo.com", "REMINDER");
        Contact emailD = this.contactFactory.createEmail("d@foo.com", "HOME");
        Contact emailE = this.contactFactory.createEmail("e@foo.com", true, new String[0]);
        this.save((IMObject)emailA);
        this.save((IMObject)emailB);
        this.save((IMObject)emailC);
        this.save((IMObject)emailD);
        this.save((IMObject)emailE);
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContacts(emailA, emailB, emailC, emailD, emailE)).build();
        JXPathContext context1 = this.createContext(customer);
        Assert.assertEquals((Object)emailE, (Object)context1.getValue("email:preferred(.)"));
        Assert.assertEquals((Object)emailA, (Object)context1.getValue("email:billing(.)"));
        Assert.assertEquals((Object)emailB, (Object)context1.getValue("email:correspondence(.)"));
        Assert.assertEquals((Object)emailC, (Object)context1.getValue("email:reminder(.)"));
        Assert.assertEquals((Object)emailD, (Object)context1.getValue("email:purpose(., 'HOME')"));
        JXPathContext context2 = this.createContext(new Object());
        Assert.assertEquals((Object)emailE, (Object)context2.getValue("email:preferred(" + customer.getId() + ")"));
        Assert.assertEquals((Object)emailA, (Object)context2.getValue("email:billing(" + customer.getId() + ")"));
        Assert.assertEquals((Object)emailB, (Object)context2.getValue("email:correspondence(" + customer.getId() + ")"));
        Assert.assertEquals((Object)emailC, (Object)context2.getValue("email:reminder(" + customer.getId() + ")"));
        Assert.assertEquals((Object)emailD, (Object)context2.getValue("email:purpose(" + customer.getId() + ", 'HOME')"));
    }

    @Test
    public void testNoContacts() {
        Party customer1 = this.customerFactory.createCustomer();
        JXPathContext context1 = this.createContext(customer1);
        Assert.assertNull((Object)context1.getValue("email:preferred(.)"));
        Assert.assertNull((Object)context1.getValue("email:billing(.)"));
        Assert.assertNull((Object)context1.getValue("email:correspondence(.)"));
        Assert.assertNull((Object)context1.getValue("email:reminder(.)"));
        Assert.assertNull((Object)context1.getValue("email:purpose(., 'HOME')"));
        Party customer2 = (Party)((TestCustomerBuilder)((TestLocationContactBuilder)((TestLocationContactBuilder)this.customerFactory.newCustomer().newLocation().preferred()).purposes("BILLING", "CORRESPONDENCE", "REMINDER", "HOME")).add()).build();
        Assert.assertEquals((long)1L, (long)customer2.getContacts().size());
        JXPathContext context2 = this.createContext(customer2);
        Assert.assertNull((Object)context2.getValue("email:preferred(.)"));
        Assert.assertNull((Object)context2.getValue("email:billing(.)"));
        Assert.assertNull((Object)context2.getValue("email:correspondence(.)"));
        Assert.assertNull((Object)context2.getValue("email:reminder(.)"));
        Assert.assertNull((Object)context2.getValue("email:purpose(., 'HOME')"));
    }

    @Test
    public void testNull() {
        JXPathContext context3 = this.createContext(new Object());
        Assert.assertNull((Object)context3.getValue("email:preferred(null)"));
        Assert.assertNull((Object)context3.getValue("email:billing(null)"));
        Assert.assertNull((Object)context3.getValue("email:correspondence(null)"));
        Assert.assertNull((Object)context3.getValue("email:reminder(null)"));
        Assert.assertNull((Object)context3.getValue("email:purpose(null, 'WORK')"));
    }

    private JXPathContext createContext(Object object) {
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new EmailFunctions((PartyRules)this.customerRules, (ArchetypeService)this.getArchetypeService()));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

