/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.tools.account;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import java.io.File;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceGenerator;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceUpdater;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

public class AccountBalanceTool {
    private final IArchetypeService service;
    private final CustomerBalanceUpdater updater;
    private final PlatformTransactionManager transactionManager;
    private boolean failOnError = false;
    private int errors = 0;
    private static final Logger log = LoggerFactory.getLogger(AccountBalanceTool.class);
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";
    private static final String[] SHORT_NAMES = new String[]{"party.customerperson", "party.organisationOTC"};

    public AccountBalanceTool(IArchetypeService service, CustomerBalanceUpdater updater, PlatformTransactionManager transactionManager) {
        if (service instanceof IArchetypeRuleService) {
            throw new IllegalStateException("Rules must be disabled to run " + AccountBalanceTool.class.getName());
        }
        this.service = service;
        this.updater = updater;
        this.transactionManager = transactionManager;
    }

    public void generate(String name) {
        ArchetypeQuery query = this.createNameQuery(name);
        this.generate(query);
    }

    public void generate(long id) {
        ArchetypeQuery query = this.createIdQuery(id);
        this.generate(query);
    }

    public void generate(Party customer) {
        log.info("Generating account balance for {}, ID={}", (Object)customer.getName(), (Object)customer.getId());
        BalanceCalculator calc = new BalanceCalculator(this.service);
        BigDecimal oldBalance = calc.getBalance(customer);
        Generator generator = new Generator(customer);
        BigDecimal balance = generator.generate();
        log.info("\tProcessed {} of {} acts", (Object)generator.getModified(), (Object)generator.getProcessed());
        log.info("\tUpdated account balance from {} to {}", (Object)oldBalance, (Object)balance);
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean check(String name) {
        ArchetypeQuery query = this.createNameQuery(name);
        return this.check(query);
    }

    public boolean check(long id) {
        ArchetypeQuery query = this.createIdQuery(id);
        return this.check(query);
    }

    public boolean check(Party customer) {
        log.info("Checking account balance for {}, ID={}", (Object)customer.getName(), (Object)customer.getId());
        BalanceCalculator calc = new BalanceCalculator(this.service);
        boolean result = false;
        try {
            BigDecimal expected = calc.getDefinitiveBalance(customer);
            BigDecimal actual = calc.getBalance(customer);
            boolean bl = result = expected.compareTo(actual) == 0;
            if (!result) {
                log.error("Failed to check account balance for {}, ID={}: expected balance={}, actual balance={}", new Object[]{customer.getName(), customer.getId(), expected, actual});
            }
        }
        catch (CustomerAccountRuleException exception) {
            log.error("Failed to check account balance for {}, ID={}: {}", new Object[]{customer.getName(), customer.getId(), exception.getMessage()});
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            JSAP parser = AccountBalanceTool.createParser();
            JSAPResult config = parser.parse(args);
            if (!config.success()) {
                AccountBalanceTool.displayUsage(parser);
            } else {
                String contextPath = config.getString("context");
                String name = config.getString("name");
                long id = config.getLong("id");
                boolean generate = config.getBoolean("generate");
                boolean check = config.getBoolean("check");
                Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
                IArchetypeService service = (IArchetypeService)context.getBean("archetypeService");
                CustomerBalanceUpdater updater = (CustomerBalanceUpdater)context.getBean(CustomerBalanceUpdater.class);
                PlatformTransactionManager transactionManager = (PlatformTransactionManager)context.getBean(PlatformTransactionManager.class);
                AccountBalanceTool tool = new AccountBalanceTool(service, updater, transactionManager);
                if (check) {
                    if (id == -1L) {
                        tool.check(name);
                    } else {
                        tool.check(id);
                    }
                } else if (generate) {
                    tool.setFailOnError(config.getBoolean("failOnError"));
                    if (id == -1L) {
                        tool.generate(name);
                    } else {
                        tool.generate(id);
                    }
                } else {
                    AccountBalanceTool.displayUsage(parser);
                }
            }
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
        }
    }

    private void generate(ArchetypeQuery query) {
        List<String> nodes = Collections.singletonList("name");
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query, nodes);
        int count = 0;
        while (iterator.hasNext()) {
            Party customer = (Party)iterator.next();
            try {
                this.generate(customer);
                ++count;
            }
            catch (OpenVPMSException exception) {
                if (this.failOnError) {
                    throw exception;
                }
                ++this.errors;
                log.error("Failed to generate account balance for {}", (Object)customer.getName(), (Object)exception);
            }
        }
        log.info("Generated account balances for {} customers", (Object)count);
        if (this.errors != 0) {
            log.warn("There were {} errors", (Object)this.errors);
        } else {
            log.info("There were no errors");
        }
    }

    private boolean check(ArchetypeQuery query) {
        boolean result = true;
        List<String> nodes = Collections.singletonList("name");
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query, nodes);
        int count = 0;
        while (iterator.hasNext()) {
            Party customer = (Party)iterator.next();
            try {
                boolean ok = this.check(customer);
                ++count;
                if (ok) continue;
                result = false;
                if (this.failOnError) {
                    return result;
                }
                ++this.errors;
            }
            catch (OpenVPMSException exception) {
                if (this.failOnError) {
                    throw exception;
                }
                ++this.errors;
                log.error("Failed to check account balance for {}", (Object)customer.getName(), (Object)exception);
            }
        }
        log.info("Checked account balances for {} customers", (Object)count);
        if (this.errors != 0) {
            log.warn("There were {} errors", (Object)this.errors);
        } else {
            log.info("There were no errors");
        }
        return result;
    }

    private ArchetypeQuery createNameQuery(String name) {
        ArchetypeQuery query = new ArchetypeQuery(SHORT_NAMES, true, false);
        query.setMaxResults(1000);
        if (!StringUtils.isEmpty((CharSequence)name)) {
            query.add((IConstraint)new NodeConstraint("name", (Object)name));
        }
        query.add((IConstraint)new NodeSortConstraint("name"));
        query.add((IConstraint)new NodeSortConstraint("id"));
        return query;
    }

    private ArchetypeQuery createIdQuery(long id) {
        ArchetypeQuery query = new ArchetypeQuery(SHORT_NAMES, true, false);
        query.add((IConstraint)new NodeConstraint("id", (Object)id));
        return query;
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new FlaggedOption("name").setShortFlag('n').setLongFlag("name").setHelp("Customer name. May contain wildcards"));
        parser.registerParameter(new FlaggedOption("id").setShortFlag('i').setLongFlag("id").setStringParser((StringParser)JSAP.LONG_PARSER).setDefault("-1").setHelp("Customer identifier."));
        parser.registerParameter(new Switch("check").setShortFlag('c').setLongFlag("check").setDefault("false").setHelp("Check account balances."));
        parser.registerParameter(new Switch("generate").setShortFlag('g').setLongFlag("generate").setDefault("false").setHelp("Generate account balances."));
        parser.registerParameter(new FlaggedOption("failOnError").setShortFlag('e').setLongFlag("failOnError").setDefault("false").setStringParser((StringParser)BooleanStringParser.getParser()).setHelp("Fail on error"));
        parser.registerParameter(new FlaggedOption("context").setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("Application context path"));
        return parser;
    }

    private static void displayUsage(JSAP parser) {
        System.err.println();
        System.err.println("Usage: java " + AccountBalanceTool.class.getName());
        System.err.println("                " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.exit(1);
    }

    private class Generator
    extends CustomerBalanceGenerator {
        Generator(Party customer) {
            super(customer, AccountBalanceTool.this.service, AccountBalanceTool.this.updater, AccountBalanceTool.this.transactionManager);
        }

        @Override
        protected void changed(FinancialAct act, BigDecimal fromTotal, BigDecimal toTotal) {
            String displayName = DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)AccountBalanceTool.this.service);
            log.warn("Updated {} dated {}  from {} to {}", new Object[]{displayName, act.getActivityStartTime(), fromTotal, toTotal});
        }
    }
}

