/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow.roster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.workflow.AbstractCalendarService;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.archetype.rules.workflow.roster.RosterEventByAreaFactory;
import org.openvpms.archetype.rules.workflow.roster.RosterEventByUserFactory;
import org.openvpms.archetype.rules.workflow.roster.RosterUserCache;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.MonitoringIMObjectCache;
import org.openvpms.component.business.service.cache.EhCacheable;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.util.PropertySet;

public class RosterService
extends AbstractCalendarService {
    private final RosterUserCache userCache;
    private final MonitoringIMObjectCache<Entity> areaCache;
    private final MonitoringIMObjectCache<Entity> scheduleCache;

    public RosterService(IArchetypeService service, EhcacheManager cacheManager) {
        super(new String[]{"act.rosterEvent"}, service, cacheManager, "rosterAreaCache", new RosterEventByAreaFactory(service));
        this.userCache = new RosterUserCache(cacheManager, "rosterUserCache", new RosterEventByUserFactory(service));
        this.areaCache = new MonitoringIMObjectCache(service, "entity.rosterArea", Entity.class, true);
        this.scheduleCache = new MonitoringIMObjectCache(service, "party.organisationSchedule", Entity.class, true);
    }

    public ScheduleEvents getUserEvents(User user, Date from, Date to) {
        return this.userCache.getEvents((Entity)user, from, to);
    }

    public long getUserModHash(User user, Date from, Date to) {
        return this.userCache.getModHash((Entity)user, from, to);
    }

    public List<Entity> getSchedules(Reference area) {
        List<Entity> result;
        Entity object = (Entity)this.areaCache.getObject(area);
        if (object != null) {
            result = new ArrayList();
            IMObjectBean bean = this.getService().getBean((IMObject)object);
            for (Reference reference : bean.getTargetRefs("schedules")) {
                Entity schedule = (Entity)this.scheduleCache.getObject(reference);
                if (schedule == null || !schedule.isActive()) continue;
                result.add(schedule);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<Entity> getAreas(Reference schedule) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        IArchetypeService service = this.getService();
        for (Entity area : this.areaCache.getObjects()) {
            IMObjectBean bean;
            if (!area.isActive() || !(bean = service.getBean((IMObject)area)).getTargetRefs("schedules").contains(schedule)) continue;
            result.add(area);
        }
        return result;
    }

    public List<UserEvent> getUserEvents(User user, Party location, Date from, Date to) {
        return this.getUserEvents(user, location != null ? location.getObjectReference() : null, from, to);
    }

    public List<UserEvent> getUserEvents(User user, Reference location, Date from, Date to) {
        ArrayList<UserEvent> result = new ArrayList<UserEvent>();
        ArchetypeQuery query = new ArchetypeQuery("act.rosterEvent", false, false);
        query.getArchetypeConstraint().setAlias("act");
        query.add((IConstraint)new ObjectRefSelectConstraint("act"));
        query.add((IConstraint)new ObjectRefSelectConstraint("schedule.entity"));
        query.add((IConstraint)new NodeSelectConstraint("startTime"));
        query.add((IConstraint)new NodeSelectConstraint("endTime"));
        JoinConstraint userpartic = this.createJoin("user");
        userpartic.add((IConstraint)Constraints.eq((String)"entity", (Object)user));
        query.add((IConstraint)userpartic);
        if (location != null) {
            JoinConstraint locationpartic = this.createJoin("location");
            locationpartic.add((IConstraint)Constraints.eq((String)"entity", (Reference)location));
            query.add((IConstraint)locationpartic);
        }
        query.add((IConstraint)Constraints.join((String)"schedule"));
        query.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.lt((String)"startTime", (Object)to), Constraints.gt((String)"endTime", (Object)from)}));
        IArchetypeService service = this.getService();
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            PropertySet set = (PropertySet)iterator.next();
            result.add(new UserEvent((Reference)set.getReference("act.reference"), (Reference)set.getReference("schedule.entity.reference"), set.getDate("act.startTime"), set.getDate("act.endTime")));
        }
        return result;
    }

    public List<Times> getOverlappingEvents(List<Times> events, User user, int limit) {
        ArrayList<Times> result = new ArrayList<Times>();
        ObjectSetQueryIterator iterator = this.createOverlappingEventIterator(events, "user", user.getObjectReference(), limit);
        while (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            result.add(this.createTimes(set));
        }
        return !result.isEmpty() ? result : null;
    }

    public EhCacheable getUserCache() {
        return this.userCache;
    }

    @Override
    public void destroy() throws Exception {
        try {
            super.destroy();
        }
        finally {
            this.areaCache.destroy();
            this.scheduleCache.destroy();
        }
    }

    @Override
    protected void addEvent(Act event) {
        super.addEvent(event);
        this.userCache.addEvent(event);
    }

    @Override
    protected void removeEvent(Act event) {
        super.removeEvent(event);
        this.userCache.removeEvent(event);
    }

    private JoinConstraint createJoin(String node) {
        JoinConstraint userpartic = Constraints.join((String)node);
        userpartic.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.rosterEvent"));
        return userpartic;
    }

    public static class UserEvent {
        private final Reference event;
        private final Reference area;
        private final Date startTime;
        private final Date endTime;

        UserEvent(Reference event, Reference area, Date startTime, Date endTime) {
            this.event = event;
            this.area = area;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Reference getEvent() {
            return this.event;
        }

        public Reference getArea() {
            return this.area;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }
    }
}

