/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow.cache;

import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.cache.EventHandle;
import org.openvpms.component.system.common.util.PropertySet;

public abstract class Event {
    private final long id;
    private PropertySet event;
    private long version;
    private long entityId;
    private int modCount;
    private static final String[] VERSION_KEYS = new String[]{"scheduleParticipation.version", "customerParticipation.version", "patientParticipation.version", "clinicianParticipation.version", "scheduleTypeParticipation.version", "userParticipation.version"};

    protected Event(PropertySet event) {
        this.id = event.getReference("act.objectReference").getId();
        this.setEvent(event, event.getLong("act.version"));
    }

    public synchronized boolean update(PropertySet event) {
        boolean update = false;
        long otherVersion = event.getLong("act.version");
        if (this.version < otherVersion) {
            update = true;
        } else if (this.version == otherVersion) {
            int value = 0;
            for (String key : VERSION_KEYS) {
                value = this.compareVersions(key, event);
                if (value == 0) continue;
                if (value >= 0) break;
                update = true;
                break;
            }
            if (!update && value == 0) {
                update = true;
            }
        }
        if (update) {
            this.setEvent(event, otherVersion);
        }
        return update;
    }

    public long getId() {
        return this.id;
    }

    public synchronized PropertySet getEvent() {
        return this.event;
    }

    public synchronized boolean intersects(Date from, Date to) {
        Date startTime = this.event.getDate("act.startTime");
        Date endTime = this.event.getDate("act.endTime");
        return DateRules.intersects(from, to, startTime, endTime);
    }

    public synchronized long getEntityId() {
        return this.entityId;
    }

    public synchronized EventHandle getHandle(long entityId, Date from, Date to) {
        return this.isFor(entityId, from, to) ? new EventHandle(this, this.modCount) : null;
    }

    public synchronized PropertySet getEvent(long entityId, Date from, Date to, EventHandle handle) {
        PropertySet result;
        if (this.modCount == handle.getModCount()) {
            result = this.event;
        } else if (this.isFor(entityId, from, to)) {
            handle.setModCount(this.modCount);
            result = this.event;
        } else {
            result = null;
        }
        return result;
    }

    public synchronized String toString() {
        Date start = this.event.getDate("act.startTime");
        Date end = this.event.getDate("act.endTime");
        return "reference=" + this.event.getReference("act.objectReference") + ", start=" + (start != null ? DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(start) : null) + ", end=" + (end != null ? DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(end) : null) + ", entity=" + this.entityId + ", version=" + this.version + ", modCount=" + this.modCount;
    }

    protected abstract long getEntityId(PropertySet var1);

    private boolean isFor(long entityId, Date from, Date to) {
        return this.entityId == entityId && this.intersects(from, to);
    }

    private int compareVersions(String key, PropertySet other) {
        if (!this.event.exists(key) || !other.exists(key)) {
            return 0;
        }
        long version1 = this.event.getLong(key);
        long version2 = other.getLong(key);
        return Long.compare(version1, version2);
    }

    private void setEvent(PropertySet event, long version) {
        this.event = event;
        this.version = version;
        this.entityId = this.getEntityId(event);
        ++this.modCount;
    }
}

