/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow.cache;

import java.util.Date;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.openvpms.archetype.rules.workflow.cache.DayCache;
import org.openvpms.archetype.rules.workflow.cache.Event;

class DayCaches {
    private final ReferenceMap<Date, DayCache> days = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
    private long id;

    DayCaches(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DayCache day) {
        ReferenceMap<Date, DayCache> referenceMap = this.days;
        synchronized (referenceMap) {
            day.setOwner(this);
            this.days.put((Object)day.getFrom(), (Object)day);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event event) {
        ReferenceMap<Date, DayCache> referenceMap = this.days;
        synchronized (referenceMap) {
            for (DayCache cache : this.days.values()) {
                cache.addIfIntersects(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(Event event) {
        DayCache[] dayCacheArray = this.days;
        synchronized (this.days) {
            DayCache[] caches = this.days.values().toArray(new DayCache[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (DayCache cache : caches) {
                cache.removeIfIntersects(event);
            }
            return;
        }
    }
}

