/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import java.util.Objects;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;

public class Times
implements Comparable<Times> {
    private final Reference reference;
    private final Date startTime;
    private final Date endTime;

    public Times(Date startTime, Date endTime) {
        this(null, startTime, endTime);
    }

    public Times(Reference reference, Date startTime, Date endTime) {
        this.reference = reference;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long getId() {
        return this.reference != null ? this.reference.getId() : -1L;
    }

    public Reference getReference() {
        return this.reference;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isInstant() {
        return this.startTime != null && this.endTime != null && DateRules.compareTo(this.startTime, this.endTime) == 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Times) {
            return this.compareTo((Times)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.getId());
    }

    @Override
    public int compareTo(Times object) {
        int result = DateRules.compareTo(this.startTime, object.getStartTime());
        if (result == 0) {
            result = DateRules.compareTo(this.endTime, object.getEndTime());
        }
        if (result == 0) {
            result = Long.compare(this.getId(), object.getId());
        }
        return result;
    }

    public boolean intersects(Date from, Date to) {
        return this.isInstant() ? DateRules.between(this.startTime, from, to) : DateRules.intersects(this.startTime, this.endTime, from, to);
    }

    public static Times create(Act act) {
        Date startTime = act.getActivityStartTime();
        Date endTime = act.getActivityEndTime();
        return startTime != null && endTime != null ? new Times(act.getObjectReference(), startTime, endTime) : null;
    }
}

