/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.util;

import java.util.List;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;

public class EntityRelationshipHelper {
    private static final String DEFAULT = "default";

    private EntityRelationshipHelper() {
    }

    public static Reference getDefaultTargetRef(Entity entity, String node, ArchetypeService service) {
        return EntityRelationshipHelper.getDefaultTargetRef(entity, node, true, service);
    }

    public static Reference getDefaultTargetRef(Entity entity, String node, boolean useNonDefault, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)entity);
        return EntityRelationshipHelper.getDefaultTargetRef(bean.getValues(node, EntityRelationship.class), useNonDefault, service);
    }

    public static Entity getDefaultTarget(Entity entity, String node, ArchetypeService service) {
        return EntityRelationshipHelper.getDefaultTarget(entity, node, true, service);
    }

    public static Entity getDefaultTarget(Entity entity, String node, boolean useNonDefault, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)entity);
        return EntityRelationshipHelper.getDefaultTarget(bean.getValues(node, Relationship.class), useNonDefault, service);
    }

    public static Entity getDefaultTarget(List<Relationship> relationships, ArchetypeService service) {
        return EntityRelationshipHelper.getDefaultTarget(relationships, true, service);
    }

    public static Entity getDefaultTarget(List<Relationship> relationships, boolean useNonDefault, ArchetypeService service) {
        Entity result = null;
        for (Relationship relationship : relationships) {
            Entity entity;
            if (!relationship.isActive()) continue;
            if (result == null && useNonDefault) {
                result = EntityRelationshipHelper.getEntity(relationship.getTarget(), service);
                continue;
            }
            if (!EntityRelationshipHelper.isDefault(relationship, service) || (entity = EntityRelationshipHelper.getEntity(relationship.getTarget(), service)) == null) continue;
            result = entity;
            break;
        }
        return result;
    }

    public static Reference getDefaultTargetRef(List<EntityRelationship> relationships, boolean useNonDefault, ArchetypeService service) {
        Reference result = null;
        for (EntityRelationship relationship : relationships) {
            if (!relationship.isActive()) continue;
            if (result == null && useNonDefault) {
                result = relationship.getTarget();
                continue;
            }
            if (!EntityRelationshipHelper.isDefault((Relationship)relationship, service) || (result = relationship.getTarget()) == null) continue;
            break;
        }
        return result;
    }

    public static void setDefault(Entity entity, String node, Relationship relationship, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)entity);
        List relationships = bean.getValues(node, Relationship.class);
        for (Relationship r : relationships) {
            if (r == relationship) continue;
            IMObjectBean relBean = service.getBean((IMObject)r);
            relBean.setValue(DEFAULT, (Object)false);
        }
        IMObjectBean relBean = service.getBean((IMObject)relationship);
        relBean.setValue(DEFAULT, (Object)true);
    }

    private static boolean isDefault(Relationship relationship, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)relationship);
        return bean.hasNode(DEFAULT) && bean.getBoolean(DEFAULT);
    }

    private static Entity getEntity(Reference ref, ArchetypeService service) {
        Entity result = null;
        if (ref != null) {
            result = (Entity)service.get(ref, true);
        }
        return result;
    }
}

