/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.supplier.Stock;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OrderGenerator {
    private final TaxRules taxRules;
    private final IArchetypeService service;
    private static final String QUANTITY = "quantity";
    private static final String PACKAGE_SIZE = "packageSize";
    private static final String PACKAGE_UNITS = "packageUnits";
    private static final String REORDER_CODE = "reorderCode";
    private static final String LIST_PRICE = "listPrice";
    private static final List<String> NAMES = Arrays.asList("productId", "productShortName", "productLinkId", "productSupplierId", "quantity", "idealQty", "criticalQty", "packageSize", "packageUnits", "reorderCode", "reorderDesc", "nettPrice", "listPrice", "orderedQty", "receivedQty", "cancelledQty");
    private static final Logger log = LoggerFactory.getLogger(OrderGenerator.class);

    public OrderGenerator(TaxRules taxRules, IArchetypeService service) {
        this.taxRules = taxRules;
        this.service = service;
    }

    public List<Stock> getOrderableStock(Party supplier, Party stockLocation, boolean belowIdealQuantity) {
        ArrayList<Stock> result = new ArrayList<Stock>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("stockLocationId", stockLocation.getId());
        parameters.put("supplierId", supplier.getId());
        parameters.put("supplier", supplier.getObjectReference().toString());
        NamedQuery query = new NamedQuery("getStockToOrderByStockLocationAndSupplier", NAMES, parameters);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            Stock stock;
            ObjectSet set = (ObjectSet)iterator.next();
            Product product = (Product)this.getObject("product", set);
            if (product == null || (stock = this.getStock(set, product, supplier, stockLocation, belowIdealQuantity)) == null) continue;
            result.add(stock);
        }
        return result;
    }

    public List<FinancialAct> createOrder(Party supplier, Party stockLocation, boolean belowIdealQuantity) {
        ActCalculator calculator = new ActCalculator((ArchetypeService)this.service);
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        List<Stock> toOrder = this.getOrderableStock(supplier, stockLocation, belowIdealQuantity);
        if (!toOrder.isEmpty()) {
            FinancialAct order = (FinancialAct)this.service.create("act.supplierOrder", FinancialAct.class);
            result.add(order);
            IMObjectBean bean = this.service.getBean((IMObject)order);
            bean.setTarget("supplier", (IMObject)supplier);
            bean.setTarget("stockLocation", (IMObject)stockLocation);
            ArrayList<FinancialAct> items = new ArrayList<FinancialAct>();
            for (Stock stock : toOrder) {
                FinancialAct item = (FinancialAct)this.service.create("act.supplierOrderItem", FinancialAct.class);
                bean.addTarget("items", (IMObject)item, "order");
                items.add(item);
                IMObjectBean itemBean = this.service.getBean((IMObject)item);
                itemBean.setValue("startTime", (Object)order.getActivityStartTime());
                itemBean.setTarget("product", (IMObject)stock.getProduct());
                itemBean.setValue(REORDER_CODE, (Object)stock.getReorderCode());
                itemBean.setValue("reorderDescription", (Object)stock.getReorderDescription());
                itemBean.setValue(PACKAGE_SIZE, (Object)stock.getPackageSize());
                itemBean.setValue(PACKAGE_UNITS, (Object)stock.getPackageUnits());
                itemBean.setValue(QUANTITY, (Object)stock.getToOrder());
                itemBean.setValue("unitPrice", (Object)stock.getUnitPrice());
                itemBean.setValue(LIST_PRICE, (Object)stock.getListPrice());
                BigDecimal amount = stock.getToOrder().multiply(stock.getUnitPrice());
                BigDecimal tax = this.taxRules.calculateTax(amount, stock.getProduct(), false);
                tax = MathRules.round(tax, 2);
                itemBean.setValue("tax", (Object)tax);
                this.service.deriveValues((IMObject)item);
            }
            bean.setValue("amount", (Object)calculator.sum((Act)order, items, "total"));
            bean.setValue("tax", (Object)calculator.sum((Act)order, items, "tax"));
            this.service.deriveValues((IMObject)order);
            result.addAll(items);
        }
        return result;
    }

    private Stock getStock(ObjectSet set, Product product, Party supplier, Party stockLocation, boolean belowIdealQuantity) {
        Stock stock = null;
        long productSupplierId = set.getLong("productSupplierId");
        BigDecimal quantity = this.getDecimal(QUANTITY, set);
        BigDecimal idealQty = this.getDecimal("idealQty", set);
        BigDecimal criticalQty = this.getDecimal("criticalQty", set);
        int packageSize = set.getInt(PACKAGE_SIZE);
        String packageUnits = set.getString(PACKAGE_UNITS);
        String reorderCode = set.getString(REORDER_CODE);
        String reorderDesc = set.getString("reorderDesc");
        BigDecimal nettPrice = this.getDecimal("nettPrice", set);
        BigDecimal listPrice = this.getDecimal(LIST_PRICE, set);
        BigDecimal orderedQty = this.getDecimal("orderedQty", set);
        BigDecimal receivedQty = this.getDecimal("receivedQty", set);
        BigDecimal cancelledQty = this.getDecimal("cancelledQty", set);
        if (packageSize != 0) {
            BigDecimal decSize = BigDecimal.valueOf(packageSize);
            BigDecimal onOrder = receivedQty.compareTo(orderedQty) > 0 ? BigDecimal.ZERO : orderedQty.subtract(receivedQty).subtract(cancelledQty);
            BigDecimal current = quantity.add(onOrder);
            BigDecimal toOrder = BigDecimal.ZERO;
            BigDecimal units = idealQty.subtract(current);
            if (!MathRules.equals(BigDecimal.ZERO, units)) {
                toOrder = units.divide(decSize, 0, RoundingMode.UP);
            }
            if (toOrder.compareTo(BigDecimal.ZERO) > 0 && (belowIdealQuantity && current.compareTo(idealQty) <= 0 || current.compareTo(criticalQty) <= 0)) {
                stock = new Stock(product, stockLocation, supplier, productSupplierId, quantity, idealQty, onOrder, toOrder, reorderCode, reorderDesc, packageSize, packageUnits, nettPrice, listPrice);
            }
            if (log.isDebugEnabled()) {
                log.debug("Stock: product=" + product.getName() + " (" + product.getId() + "), location=" + stockLocation.getName() + " (" + stockLocation.getId() + "), supplier=" + supplier.getName() + " (" + supplier.getId() + "), onHand=" + quantity + ", onOrder=" + onOrder + ", toOrder=" + toOrder + ", current=" + current + ", idealQty=" + idealQty + ", criticalQty=" + criticalQty + ", packageSize=" + packageSize + ", packageUnits=" + packageUnits + ", order=" + (stock != null));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Cannot order product=" + product.getName() + " (" + product.getId() + ") at location=" + stockLocation.getName() + " (" + stockLocation.getId() + ") from supplier=" + supplier.getName() + " (" + supplier.getId() + ") - no package size");
        }
        return stock;
    }

    private IMObject getObject(String prefix, ObjectSet set) {
        String shortName = set.getString(prefix + "ShortName");
        if (shortName != null) {
            long id = set.getLong(prefix + "Id");
            return this.service.get(shortName, id);
        }
        return null;
    }

    private BigDecimal getDecimal(String name, ObjectSet set) {
        BigDecimal result = set.getBigDecimal(name, BigDecimal.ZERO);
        if (result.compareTo(BigDecimal.ZERO) < 0) {
            result = BigDecimal.ZERO;
        }
        return result;
    }
}

