/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock.io;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.product.io.ProductIOException;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.archetype.rules.stock.io.StockDataSet;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

class StockDataFilter {
    private final IArchetypeService service;

    public StockDataFilter(IArchetypeService service) {
        this.service = service;
    }

    public StockDataSet filter(List<StockData> input) {
        long stockLocationId = -1L;
        String stockLocationName = null;
        Reference stockLocation = null;
        ArrayList<StockData> output = new ArrayList<StockData>();
        ArrayList<StockData> errors = new ArrayList<StockData>();
        for (StockData data : input) {
            try {
                BigDecimal newQuantity;
                if (stockLocation == null) {
                    stockLocationId = data.getStockLocationId();
                    stockLocationName = data.getStockLocationName();
                    stockLocation = this.getStockLocation(data);
                } else {
                    this.checkStockLocation(data, stockLocationId, stockLocationName);
                }
                data.setProduct(this.getProduct(data));
                BigDecimal quantity = data.getQuantity();
                if (quantity.compareTo(newQuantity = data.getNewQuantity()) == 0) continue;
                data.setStockLocation(stockLocation);
                output.add(data);
            }
            catch (ProductIOException exception) {
                data.setError(exception.getMessage());
                errors.add(data);
            }
        }
        return new StockDataSet(output, errors);
    }

    private void checkStockLocation(StockData data, long stockLocationId, String stockLocationName) {
        if (stockLocationId != data.getStockLocationId()) {
            throw new ProductIOException(ProductIOException.ErrorCode.UnexpectedValue, data.getLine(), Long.toString(stockLocationId), "Stock Location Identifier", Long.toString(data.getStockLocationId()));
        }
        if (!stockLocationName.equalsIgnoreCase(data.getStockLocationName())) {
            throw new ProductIOException(ProductIOException.ErrorCode.UnexpectedValue, data.getLine(), stockLocationName, "Stock Location Name", data.getStockLocationName());
        }
    }

    private Reference getStockLocation(StockData data) {
        Reference reference = this.getReference("party.organisationStockLocation", data.getStockLocationId(), data.getStockLocationName(), data.getLine());
        if (reference == null) {
            throw new ProductIOException(ProductIOException.ErrorCode.StockLocationNotFound, data.getLine(), new Object[0]);
        }
        return reference;
    }

    private Reference getProduct(StockData data) {
        Reference reference = this.getReference("product.*", data.getProductId(), data.getProductName(), data.getLine());
        if (reference == null) {
            throw new ProductIOException(ProductIOException.ErrorCode.ProductNotFound, data.getLine(), new Object[0]);
        }
        return reference;
    }

    private Reference getReference(String shortName, long id, String name, int line) {
        ArchetypeQuery query = new ArchetypeQuery(shortName);
        query.add((IConstraint)Constraints.eq((String)"id", (Object)id));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        if (iterator.hasNext()) {
            IMObject object = (IMObject)iterator.next();
            if (!name.equalsIgnoreCase(object.getName())) {
                throw new ProductIOException(ProductIOException.ErrorCode.InvalidName, line, object.getName(), name);
            }
            return object.getObjectReference();
        }
        return null;
    }
}

