/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock.io;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.component.business.domain.im.document.Document;

public class StockCSVWriter {
    private final DocumentHandlers handlers;
    private final char separator;
    static final String STOCK_LOCATION_ID = "Stock Location Identifier";
    static final String STOCK_LOCATION_NAME = "Stock Location Name";
    protected static final String[] HEADER = new String[]{"Stock Location Identifier", "Stock Location Name", "Product Identifier", "Product Name", "Selling Units", "Quantity", "New Quantity"};

    public StockCSVWriter(DocumentHandlers handlers, char separator) {
        this.handlers = handlers;
        this.separator = separator;
    }

    public Document write(String name, Iterator<StockData> stock) {
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer, this.separator);
        csv.writeNext(HEADER);
        while (stock.hasNext()) {
            this.write(stock.next(), csv);
        }
        DocumentHandler handler = this.handlers.get(name, "text/csv");
        byte[] buffer = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        return handler.create(name, new ByteArrayInputStream(buffer), "text/csv", buffer.length);
    }

    private void write(StockData data, CSVWriter writer) {
        String[] line = new String[]{Long.toString(data.getStockLocationId()), data.getStockLocationName(), Long.toString(data.getProductId()), data.getProductName(), data.getSellingUnits(), data.getQuantity().toString(), data.getNewQuantity().toString()};
        writer.writeNext(line);
        if (writer.checkError()) {
            throw new IllegalStateException("Failed to write stock data");
        }
    }
}

