/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class StockRules {
    private final IArchetypeService service;
    private static final String STOCK_LOCATIONS = "stockLocations";
    private static final String QUANTITY = "quantity";

    public StockRules(IArchetypeService service) {
        this.service = service;
    }

    public Party getStockLocation(Product product, Party location) {
        Party result = null;
        Party fallback = null;
        IMObjectBean locBean = this.service.getBean((IMObject)location);
        if (locBean.getBoolean("stockControl")) {
            for (Party stockLocation : locBean.getTargets(STOCK_LOCATIONS, Party.class)) {
                if (fallback == null) {
                    fallback = stockLocation;
                }
                if (this.getStockRelationship(product, stockLocation) == null) continue;
                result = stockLocation;
                break;
            }
            if (result == null) {
                result = fallback;
            }
        }
        return result;
    }

    public BigDecimal getStock(Reference product, Reference stockLocation) {
        BigDecimal result = BigDecimal.ZERO;
        ArchetypeQuery q = new ArchetypeQuery("entityLink.productStockLocation", false, false);
        q.add((IConstraint)Constraints.eq((String)"source", (Reference)product));
        q.add((IConstraint)Constraints.eq((String)"target", (Reference)stockLocation));
        q.add((IConstraint)Constraints.sort((String)"id"));
        q.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)q);
        if (iterator.hasNext()) {
            IMObjectBean bean = this.service.getBean((IMObject)iterator.next());
            result = bean.getBigDecimal(QUANTITY, BigDecimal.ZERO);
        }
        return result;
    }

    public BigDecimal getStock(Product product, Party stockLocation) {
        BigDecimal result = BigDecimal.ZERO;
        IMObjectRelationship relationship = this.getStockRelationship(product, stockLocation);
        if (relationship != null) {
            IMObjectBean bean = this.service.getBean((IMObject)relationship);
            result = bean.getBigDecimal(QUANTITY, BigDecimal.ZERO);
        }
        return result;
    }

    public boolean hasStockRelationship(Product product, Party stockLocation) {
        return this.getStockRelationship(product, stockLocation.getObjectReference()) != null;
    }

    public void updateStock(Product product, Party stockLocation, BigDecimal quantity) {
        List<IMObject> toSave = this.calcStock(product, stockLocation.getObjectReference(), quantity);
        this.service.save(toSave);
    }

    public void transferStock(Product product, Party from, Party to, BigDecimal quantity) {
        List<IMObject> toSave = this.transfer(product, from, to, quantity);
        this.service.save(toSave);
    }

    public IMObjectRelationship getStockRelationship(Product product, Party stockLocation) {
        return this.getStockRelationship(product, stockLocation.getObjectReference());
    }

    protected IMObjectRelationship getStockRelationship(Product product, Reference stockLocation) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        Predicate predicate = Predicates.activeNow().and(Predicates.targetEquals((Reference)stockLocation));
        return (IMObjectRelationship)bean.getValue(STOCK_LOCATIONS, IMObjectRelationship.class, predicate);
    }

    protected List<IMObject> transfer(Product product, Party from, Party to, BigDecimal quantity) {
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        result.addAll(this.calcStock(product, from.getObjectReference(), quantity.negate()));
        result.addAll(this.calcStock(product, to.getObjectReference(), quantity));
        return result;
    }

    protected List<IMObject> calcStock(Product product, Reference stockLocation, BigDecimal quantity) {
        IMObjectBean prodBean = this.service.getBean((IMObject)product);
        IMObjectRelationship relationship = this.getStockRelationship(product, stockLocation);
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        if (relationship == null) {
            relationship = prodBean.addTarget(STOCK_LOCATIONS, stockLocation);
            toSave.add((IMObject)product);
        } else {
            toSave.add((IMObject)relationship);
        }
        this.calcStock((Relationship)relationship, quantity);
        return toSave;
    }

    protected void calcStock(Relationship relationship, BigDecimal quantity) {
        IMObjectBean bean = this.service.getBean((IMObject)relationship);
        BigDecimal old = bean.getBigDecimal(QUANTITY, BigDecimal.ZERO);
        BigDecimal now = old.add(quantity);
        bean.setValue(QUANTITY, (Object)now);
    }
}

