/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.ProductIOException;
import org.openvpms.archetype.rules.product.io.ProductIOHelper;
import org.openvpms.archetype.rules.product.io.ProductWriter;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;

public class ProductCSVWriter
implements ProductWriter {
    protected static final String[] HEADER = new String[]{"Product Id", "Product Name", "Product Printed Name", "Fixed Price Id", "Fixed Price", "Fixed Cost", "Fixed Price Max Discount", "Fixed Price Start Date", "Fixed Price End Date", "Default Fixed Price", "Fixed Price Groups", "Unit Price Id", "Unit Price", "Unit Cost", "Unit Price Max Discount", "Unit Price Start Date", "Unit Price End Date", "Unit Price Groups", "Tax Rate", "Notes"};
    private final IArchetypeService service;
    private final ProductPriceRules rules;
    private final TaxRules taxRules;
    private final DocumentHandlers handlers;
    static final char SEPARATOR = ',';

    public ProductCSVWriter(IArchetypeService service, ProductPriceRules rules, TaxRules taxRules, DocumentHandlers handlers) {
        this.service = service;
        this.rules = rules;
        this.taxRules = taxRules;
        this.handlers = handlers;
    }

    @Override
    public Document write(Iterator<Product> products, boolean current, boolean includeLinkedPrices, PricingGroup group) {
        Prices prices = current ? Prices.CURRENT : Prices.ALL;
        return this.write(products, prices, null, null, includeLinkedPrices, group);
    }

    @Override
    public Document write(Iterator<Product> products, java.util.Date from, java.util.Date to, boolean includeLinkedPrices, PricingGroup group) {
        return this.write(products, Prices.RANGE, from, to, includeLinkedPrices, group);
    }

    protected String getDate(java.util.Date date) {
        return date != null ? new Date(date.getTime()).toString() : null;
    }

    private Document write(Iterator<Product> products, Prices prices, java.util.Date from, java.util.Date to, boolean includeLinkedPrices, PricingGroup group) {
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer, ',');
        csv.writeNext(HEADER);
        while (products.hasNext()) {
            this.write(products.next(), prices, from, to, includeLinkedPrices, group, csv);
        }
        String name = "products-" + new Date(System.currentTimeMillis()) + ".csv";
        DocumentHandler handler = this.handlers.get(name, "text/csv");
        byte[] buffer = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        return handler.create(name, new ByteArrayInputStream(buffer), "text/csv", buffer.length);
    }

    private void write(Product product, Prices prices, java.util.Date from, java.util.Date to, boolean includeLinkedPrices, PricingGroup group, CSVWriter writer) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        String productId = bean.getString("id");
        String name = bean.getString("name");
        List<ProductPrice> fixedPrices = this.getPrices(product, "productPrice.fixedPrice", prices, from, to, includeLinkedPrices, group);
        List<ProductPrice> unitPrices = this.getPrices(product, "productPrice.unitPrice", prices, from, to, includeLinkedPrices, group);
        String printedName = bean.getString("printedName");
        String tax = this.taxRules.getTaxRate(product).toString();
        int count = Math.max(fixedPrices.size(), unitPrices.size());
        if (count == 0) {
            count = 1;
        }
        for (int i = 0; i < count; ++i) {
            ProductPrice fixedPrice = i < fixedPrices.size() ? fixedPrices.get(i) : null;
            ProductPrice unitPrice = i < unitPrices.size() ? unitPrices.get(i) : null;
            String fixedId = null;
            String fixed = null;
            String fixedCost = null;
            String fixedMaxDiscount = null;
            String fixedStartDate = null;
            String fixedEndDate = null;
            String defaultFixedPrice = null;
            String fixedPriceGroups = null;
            String notes = null;
            if (fixedPrice != null) {
                IMObjectBean fixedBean = this.service.getBean((IMObject)fixedPrice);
                fixedId = fixedBean.getString("id");
                fixed = fixedPrice.getPrice().toString();
                fixedCost = fixedBean.getBigDecimal("cost", BigDecimal.ZERO).toString();
                fixedMaxDiscount = fixedBean.getBigDecimal("maxDiscount", MathRules.ONE_HUNDRED).toString();
                fixedStartDate = this.getDate(fixedPrice.getFromDate());
                fixedEndDate = this.getDate(fixedPrice.getToDate());
                defaultFixedPrice = fixedBean.getString("default", "false").toLowerCase();
                fixedPriceGroups = this.getGroups(fixedPrice);
                if (!Objects.equals(fixedPrice.getProduct(), product)) {
                    notes = new ProductIOException(ProductIOException.ErrorCode.LinkedPrice, -1, fixedPrice.getProduct().getName(), fixedPrice.getProduct().getId()).getMessage();
                }
            }
            String unitId = null;
            String unit = null;
            String unitCost = null;
            String unitMaxDiscount = null;
            String unitStartDate = null;
            String unitEndDate = null;
            String unitPriceGroups = null;
            if (unitPrice != null) {
                IMObjectBean unitBean = this.service.getBean((IMObject)unitPrice);
                unitId = unitBean.getString("id");
                unit = unitPrice.getPrice().toString();
                unitCost = unitBean.getBigDecimal("cost", BigDecimal.ZERO).toString();
                unitMaxDiscount = unitBean.getBigDecimal("maxDiscount", MathRules.ONE_HUNDRED).toString();
                unitStartDate = this.getDate(unitPrice.getFromDate());
                unitEndDate = this.getDate(unitPrice.getToDate());
                unitPriceGroups = this.getGroups(unitPrice);
            }
            String[] line = new String[]{productId, name, printedName, fixedId, fixed, fixedCost, fixedMaxDiscount, fixedStartDate, fixedEndDate, defaultFixedPrice, fixedPriceGroups, unitId, unit, unitCost, unitMaxDiscount, unitStartDate, unitEndDate, unitPriceGroups, tax, notes};
            writer.writeNext(line);
        }
    }

    private List<ProductPrice> getPrices(Product product, String shortName, Prices prices, java.util.Date from, java.util.Date to, boolean includeLinkedPrices, PricingGroup group) {
        ArrayList<ProductPrice> result = new ArrayList<ProductPrice>();
        if (prices == Prices.CURRENT) {
            List<ProductPrice> list = this.rules.getProductPrices(product, shortName, new java.util.Date(), null, includeLinkedPrices, group);
            if (!list.isEmpty()) {
                if (group.isAll()) {
                    result.addAll(list);
                } else {
                    result.add(list.get(0));
                }
            }
        } else if (prices == Prices.ALL) {
            result.addAll(this.rules.getProductPrices(product, shortName, includeLinkedPrices, group));
        } else {
            result.addAll(this.rules.getProductPrices(product, shortName, from, to, includeLinkedPrices, group));
        }
        return result;
    }

    private String getGroups(ProductPrice price) {
        return StringUtils.join((Object[])ProductIOHelper.getPricingGroupCodes(price, this.service), (char)' ');
    }

    private static enum Prices {
        ALL,
        CURRENT,
        RANGE;

    }
}

