/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class ProductSupplier {
    private final IMObjectBean bean;

    public ProductSupplier(Relationship relationship, IArchetypeService service) {
        this.bean = service.getBean((IMObject)relationship);
    }

    public Product getProduct() {
        return (Product)this.bean.getObject("source");
    }

    public IMObjectReference getProductRef() {
        return this.getRelationship().getSource();
    }

    public Party getSupplier() {
        return (Party)this.bean.getObject("target");
    }

    public IMObjectReference getSupplierRef() {
        return this.getRelationship().getTarget();
    }

    public Date getActiveStartTime() {
        return this.bean.getDate("activeStartTime");
    }

    public void setActiveStartTime(Date startTime) {
        this.bean.setValue("activeStartTime", (Object)startTime);
    }

    public Date getActiveEndTime() {
        return this.bean.getDate("activeEndTime");
    }

    public void setActiveEndTime(Date endTime) {
        this.bean.setValue("activeEndTime", (Object)endTime);
    }

    public void setReorderCode(String code) {
        this.bean.setValue("reorderCode", (Object)code);
    }

    public String getReorderCode() {
        return this.bean.getString("reorderCode");
    }

    public void setReorderDescription(String description) {
        this.bean.setValue("reorderDescription", (Object)description);
    }

    public String getReorderDescription() {
        return this.bean.getString("reorderDescription");
    }

    public void setBarCode(String barCode) {
        this.bean.setValue("barCode", (Object)barCode);
    }

    public String getBarCode() {
        return this.bean.getString("barCode");
    }

    public void setPackageSize(int size) {
        this.bean.setValue("packageSize", (Object)size);
    }

    public int getPackageSize() {
        return this.bean.getInt("packageSize");
    }

    public void setPackageUnits(String units) {
        this.bean.setValue("packageUnits", (Object)units);
    }

    public String getPackageUnits() {
        return this.bean.getString("packageUnits");
    }

    public int getMinimumOrderQuantity() {
        return this.bean.getInt("minimumQty");
    }

    public void setMinimumOrderQuantity(int quantity) {
        this.bean.setValue("minimumQty", (Object)quantity);
    }

    public int getOrderQuantityIncrement() {
        return this.bean.getInt("orderQtyInc");
    }

    public void setOrderQuantityIncrement(int increment) {
        this.bean.setValue("orderQtyInc", (Object)increment);
    }

    public int getLeadTime() {
        return this.bean.getInt("leadTime");
    }

    public void setLeadTime(int leadTime) {
        this.bean.setValue("leadTime", (Object)leadTime);
    }

    public String getLeadTimeUnits() {
        return this.bean.getString("leadTimeUnits");
    }

    public void setLeadTimeUnits(String units) {
        this.bean.setValue("leadTimeUnits", (Object)units);
    }

    public void setListPrice(BigDecimal price) {
        this.bean.setValue("listPrice", (Object)price);
    }

    public BigDecimal getListPrice() {
        return this.bean.getBigDecimal("listPrice");
    }

    public void setNettPrice(BigDecimal price) {
        this.bean.setValue("nettPrice", (Object)price);
    }

    public BigDecimal getNettPrice() {
        return this.bean.getBigDecimal("nettPrice");
    }

    public void setPreferred(boolean preferred) {
        this.bean.setValue("preferred", (Object)preferred);
    }

    public boolean isPreferred() {
        return this.bean.getBoolean("preferred");
    }

    public boolean isAutoPriceUpdate() {
        return this.bean.getBoolean("autoPriceUpdate");
    }

    public void setAutoPriceUpdate(boolean autoUpdate) {
        this.bean.setValue("autoPriceUpdate", (Object)autoUpdate);
    }

    public BigDecimal getCostPrice() {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal listPrice = this.getListPrice();
        int packageSize = this.getPackageSize();
        if (listPrice != null && !MathRules.isZero(listPrice) && packageSize > 0) {
            result = MathRules.divide(listPrice, packageSize, 3);
        }
        return result;
    }

    public IMObjectRelationship getRelationship() {
        return (IMObjectRelationship)this.bean.getObject(IMObjectRelationship.class);
    }

    public void save() {
        this.bean.save();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ProductSupplier) {
            ProductSupplier p = (ProductSupplier)other;
            return p.bean.getObject().equals(this.bean.getObject());
        }
        return false;
    }

    public int hashCode() {
        return this.bean.getObject().hashCode();
    }
}

