/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.ProductCopier;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.JoinConstraint;

public class ProductRules {
    private final IArchetypeService service;
    private final LookupService lookups;
    private static final int EXACT_DOSE_MATCH = 1;
    private static final int PARTIAL_DOSE_MATCH = 2;
    private static final String SUPPLIERS = "suppliers";
    private static final String PRODUCT = "product";
    private static final String TARGET = "target";
    private static final String ACTIVE_END_TIME = "activeEndTime";

    public ProductRules(IArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    public Product copy(Product product) {
        return this.copy(product, product.getName());
    }

    public Product copy(Product product, String name) {
        ProductCopier copier = new ProductCopier(product, (ArchetypeService)this.service);
        List objects = copier.apply((IMObject)product);
        Product copy = (Product)objects.get(0);
        copy.setName(name);
        this.service.save((Collection)objects);
        return copy;
    }

    public BigDecimal getDose(Product product, Weight weight, String species) {
        BigDecimal result = BigDecimal.ZERO;
        IMObjectBean bean = this.service.getBean((IMObject)product);
        BigDecimal concentration = this.getConcentration(bean);
        if (!MathRules.isZero(concentration)) {
            IMObjectBean match = null;
            WeightUnits matchUnits = null;
            List doses = bean.getTargets("doses", IMObject.class);
            for (IMObject dose : doses) {
                int doseMatch;
                WeightUnits units;
                BigDecimal maxWeight;
                IMObjectBean doseBean = this.service.getBean(dose);
                BigDecimal minWeight = doseBean.getBigDecimal("minWeight", BigDecimal.ZERO);
                if (!weight.between(minWeight, maxWeight = doseBean.getBigDecimal("maxWeight", BigDecimal.ZERO), units = WeightUnits.fromString((String)doseBean.getString("weightUnits"), (WeightUnits)WeightUnits.KILOGRAMS)) || (doseMatch = this.isDoseSpeciesMatch(doseBean, species)) <= 0) continue;
                if (match == null || doseMatch == 1) {
                    match = doseBean;
                    matchUnits = units;
                }
                if (doseMatch != 1) continue;
                break;
            }
            if (match != null) {
                result = this.calculateDose(match, weight, matchUnits, concentration);
            }
        }
        return result;
    }

    public List<ProductSupplier> getProductSuppliers(Product product, Party supplier) {
        ArrayList<ProductSupplier> result = new ArrayList<ProductSupplier>();
        IMObjectBean bean = this.service.getBean((IMObject)product);
        Predicate and = Predicates.activeNow().and(Predicates.targetEquals((IMObject)supplier));
        List relationships = bean.getValues(SUPPLIERS, Relationship.class, and);
        relationships.sort(Comparator.comparingLong(IMObject::getId));
        for (Relationship relationship : relationships) {
            result.add(new ProductSupplier(relationship, this.service));
        }
        return result;
    }

    public ProductSupplier getProductSupplier(Product product, Party supplier, String reorderCode, int packageSize, String packageUnits) {
        ProductSupplier result = null;
        ProductSupplier reorderMatch = null;
        ProductSupplier packageMatch = null;
        ProductSupplier sizeMatch = null;
        ProductSupplier zeroMatch = null;
        List<ProductSupplier> list = this.getProductSuppliers(product, supplier);
        for (ProductSupplier ps : list) {
            boolean reorderEq = Objects.equals(reorderCode, ps.getReorderCode());
            boolean sizeEq = packageSize == ps.getPackageSize();
            boolean unitEq = Objects.equals(packageUnits, ps.getPackageUnits());
            if (reorderEq && sizeEq && unitEq) {
                result = ps;
                break;
            }
            if (reorderEq && reorderCode != null) {
                reorderMatch = ps;
                continue;
            }
            if (sizeEq && unitEq) {
                packageMatch = ps;
                continue;
            }
            if (sizeEq) {
                sizeMatch = ps;
                continue;
            }
            if (ps.getPackageSize() != 0) continue;
            zeroMatch = ps;
        }
        if (result == null) {
            if (reorderMatch != null) {
                result = reorderMatch;
            } else if (packageMatch != null) {
                result = packageMatch;
            } else if (sizeMatch != null) {
                result = sizeMatch;
            } else if (zeroMatch != null) {
                result = zeroMatch;
            }
        }
        return result;
    }

    public List<ProductSupplier> getProductSuppliers(Product product) {
        ArrayList<ProductSupplier> result = new ArrayList<ProductSupplier>();
        IMObjectBean bean = this.service.getBean((IMObject)product);
        List relationships = bean.getValues(SUPPLIERS, Relationship.class, Predicates.activeNow());
        relationships.sort(Comparator.comparingLong(IMObject::getId));
        for (Relationship relationship : relationships) {
            result.add(new ProductSupplier(relationship, this.service));
        }
        return result;
    }

    public ProductSupplier createProductSupplier(Product product, Party supplier) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        Relationship rel = bean.addTarget(SUPPLIERS, (IMObject)supplier);
        return new ProductSupplier(rel, this.service);
    }

    public ProductSupplier getPreferredSupplier(Product product) {
        for (ProductSupplier supplier : this.getProductSuppliers(product)) {
            if (!supplier.isPreferred()) continue;
            return supplier;
        }
        return null;
    }

    public ProductSupplier getPreferredSupplier(Product product, Party stockLocation) {
        IMObjectBean bean;
        Reference reference;
        ProductSupplier result = null;
        Party supplier = null;
        IMObjectRelationship relationship = new StockRules(this.service).getStockRelationship(product, stockLocation);
        if (relationship != null && (reference = (bean = this.service.getBean((IMObject)relationship)).getReference("supplier")) != null) {
            supplier = (Party)this.service.get(reference, Party.class);
        }
        if (supplier != null) {
            List<ProductSupplier> suppliers = this.getProductSuppliers(product, supplier);
            if (suppliers.size() == 1) {
                result = suppliers.get(0);
            } else if (suppliers.size() > 1) {
                for (ProductSupplier ps : suppliers) {
                    if (!ps.isPreferred()) continue;
                    result = ps;
                    break;
                }
                if (result == null) {
                    result = suppliers.get(0);
                }
            }
        } else {
            result = this.getPreferredSupplier(product);
        }
        return result;
    }

    public List<Entity> getBatches(Product product, String batchNumber, Date expiryDate, Party manufacturer) {
        return this.getBatches(product.getObjectReference(), batchNumber, expiryDate, manufacturer != null ? manufacturer.getObjectReference() : null);
    }

    public List<Entity> getBatches(Reference product, String batchNumber, Date expiryDate, Reference manufacturer) {
        ArchetypeQuery query = new ArchetypeQuery("entity.productBatch", false, false);
        if (!StringUtils.isEmpty((CharSequence)batchNumber)) {
            query.add((IConstraint)Constraints.eq((String)"name", (Object)batchNumber));
        }
        JoinConstraint join = Constraints.join((String)PRODUCT, (String)"p");
        query.add((IConstraint)join.add((IConstraint)Constraints.eq((String)TARGET, (Reference)product)));
        if (expiryDate != null) {
            join.add((IConstraint)Constraints.gte((String)ACTIVE_END_TIME, (Object)DateRules.getDate(expiryDate)));
            join.add((IConstraint)Constraints.lt((String)ACTIVE_END_TIME, (Object)DateRules.getNextDate(expiryDate)));
        }
        if (manufacturer != null) {
            query.add((IConstraint)Constraints.join((String)"manufacturer").add((IConstraint)Constraints.eq((String)TARGET, (Reference)manufacturer)));
        }
        query.setMaxResults(-1);
        IPage page = this.service.get((IArchetypeQuery)query);
        query.add((IConstraint)Constraints.sort((String)"name"));
        query.add((IConstraint)Constraints.sort((String)"id"));
        ArrayList<Entity> batches = new ArrayList<Entity>();
        for (IMObject object : page.getResults()) {
            batches.add((Entity)object);
        }
        return batches;
    }

    public Entity createBatch(Product product, String batchNumber, Date expiryDate, Party manufacturer) {
        return this.createBatch(product.getObjectReference(), batchNumber, expiryDate, manufacturer != null ? manufacturer.getObjectReference() : null);
    }

    public Entity createBatch(Reference product, String batchNumber, Date expiryDate, Reference manufacturer) {
        Entity result = (Entity)this.service.create("entity.productBatch", Entity.class);
        IMObjectBean bean = this.service.getBean((IMObject)result);
        bean.setValue("name", (Object)batchNumber);
        Relationship relationship = bean.setTarget(PRODUCT, product);
        IMObjectBean relBean = this.service.getBean((IMObject)relationship);
        relBean.setValue(ACTIVE_END_TIME, (Object)expiryDate);
        if (manufacturer != null) {
            bean.setTarget("manufacturer", manufacturer);
        }
        return result;
    }

    public Date getBatchExpiry(Entity batch) {
        Date result = null;
        IMObjectBean bean = this.service.getBean((IMObject)batch);
        EntityLink product = (EntityLink)bean.getObject(PRODUCT, EntityLink.class);
        if (product != null) {
            result = product.getActiveEndTime();
        }
        return result;
    }

    public boolean canUseProductAtLocation(Product product, Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        return !bean.getTargetRefs("locations").contains(location.getObjectReference());
    }

    public boolean isRestricted(Product product) {
        Lookup schedule;
        boolean result = false;
        if (TypeHelper.isA((IMObject)product, (String)"product.medication") && (schedule = this.lookups.getLookup((IMObject)product, "drugSchedule")) != null) {
            IMObjectBean bean = this.service.getBean((IMObject)schedule);
            result = bean.getBoolean("restricted", false);
        }
        return result;
    }

    private int isDoseSpeciesMatch(IMObjectBean bean, String species) {
        int result = 0;
        Lookup doseSpecies = (Lookup)bean.getObject("species", Lookup.class);
        if (doseSpecies == null) {
            result = species == null ? 1 : 2;
        } else if (doseSpecies.getCode().equals(species)) {
            result = 1;
        }
        return result;
    }

    private BigDecimal calculateDose(IMObjectBean dose, Weight weight, WeightUnits units, BigDecimal concentration) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal converted = weight.convert(units);
        BigDecimal rate = dose.getBigDecimal("rate", BigDecimal.ZERO);
        BigDecimal quantity = dose.getBigDecimal("quantity", BigDecimal.ONE);
        int places = dose.getInt("roundTo");
        if (!(MathRules.isZero(concentration) || MathRules.isZero(rate) || MathRules.isZero(quantity))) {
            result = converted.multiply(rate).divide(concentration, places, RoundingMode.HALF_UP).multiply(quantity);
        }
        return result;
    }

    private BigDecimal getConcentration(IMObjectBean bean) {
        if (bean.isA(new String[]{"product.medication"})) {
            return bean.getBigDecimal("concentration", BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }
}

