/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.OrConstraint;

public class ProductQueryFactory {
    private ProductQueryFactory() {
    }

    public static ArchetypeQuery create(String[] archetypes, String name, String species, boolean useLocationProducts, Party location, Party stockLocation) {
        ArchetypeQuery query = new ArchetypeQuery(archetypes, true, true);
        query.getArchetypeConstraint().setAlias("p");
        if (name != null) {
            query.add((IConstraint)Constraints.eq((String)"name", (Object)name));
        }
        if (species != null) {
            ProductQueryFactory.addSpeciesConstraint(query, archetypes, species);
        }
        if (useLocationProducts && location != null) {
            ProductQueryFactory.addLocationConstraint(query, archetypes, location);
        }
        if (stockLocation != null) {
            ProductQueryFactory.addStockLocationConstraint(query, archetypes, useLocationProducts, stockLocation);
        }
        return query;
    }

    public static ArchetypeQuery addSpeciesConstraint(ArchetypeQuery query, String[] archetypes, String species) {
        String alias = query.getArchetypeConstraint().getAlias();
        query.add((IConstraint)Constraints.leftJoin((String)"species", (String)"s"));
        query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.eq((String)"s.code", (Object)species), Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String[])archetypes, (String)"p2").add((IConstraint)Constraints.join((String)"species", (String)"s2").add((IConstraint)Constraints.idEq((String)alias, (String)"p2"))))}));
        return query;
    }

    public static ArchetypeQuery addLocationConstraint(ArchetypeQuery query, String[] archetypes, Party location) {
        if (ProductQueryFactory.contains(archetypes, "product.template", "product.service")) {
            String alias = query.getArchetypeConstraint().getAlias();
            query.add((IConstraint)Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String[])archetypes, (String)"p3").add((IConstraint)Constraints.join((String)"locations", (String)"l").add((IConstraint)Constraints.eq((String)"target", (Object)location)).add((IConstraint)Constraints.idEq((String)alias, (String)"p3")))));
        }
        return query;
    }

    public static ArchetypeQuery addStockLocationConstraint(ArchetypeQuery query, String[] archetypes, boolean useLocationProducts, Party stockLocation) {
        if (ProductQueryFactory.contains(archetypes, "product.medication", "product.merchandise")) {
            String alias = query.getArchetypeConstraint().getAlias();
            query.add((IConstraint)Constraints.leftJoin((String)"stockLocations", (String)"sl"));
            OrConstraint or = Constraints.or((IConstraint[])new IConstraint[]{Constraints.eq((String)"sl.target", (Object)stockLocation), Constraints.not((IConstraint)Constraints.isA((String)alias, (String[])new String[]{"product.medication", "product.merchandise"}))});
            if (!useLocationProducts) {
                or.add((IConstraint)Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String[])archetypes, (String)"p4").add((IConstraint)Constraints.join((String)"stockLocations", (String)"sl2").add((IConstraint)Constraints.idEq((String)alias, (String)"p4")))));
            }
            query.add((IConstraint)or);
        }
        return query;
    }

    private static boolean contains(String[] archetypes, String ... matches) {
        for (String match : matches) {
            if (!ArrayUtils.contains((Object[])archetypes, (Object)match)) continue;
            return true;
        }
        return ArrayUtils.contains((Object[])archetypes, (Object)"product.*");
    }
}

