/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.collections4.ComparatorUtils;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.PriceCopyHandler;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ServiceRatio;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ProductPriceRules {
    public static final BigDecimal DEFAULT_MAX_DISCOUNT = MathRules.ONE_HUNDRED;
    private final ArchetypeService service;
    private static final int PARTIAL_MATCH = 1;
    private static final int EXACT_MATCH = 2;
    private static final String LINKED = "linked";

    public ProductPriceRules(ArchetypeService service) {
        this.service = service;
    }

    public ProductPrice getProductPrice(Product product, String shortName, Date date, Lookup group) {
        ShortNameDatePredicate predicate = new ShortNameDatePredicate(shortName, date, new PricingGroup(group));
        return this.getProductPrice(shortName, product, predicate, date);
    }

    public ProductPrice getProductPrice(Product product, BigDecimal price, String shortName, Date date, Lookup group) {
        PricePredicate predicate = new PricePredicate(price, shortName, date, new PricingGroup(group));
        return this.getProductPrice(shortName, product, predicate, date);
    }

    public List<ProductPrice> getProductPrices(Product product, String shortName, PricingGroup group) {
        return this.getProductPrices(product, shortName, true, group);
    }

    public List<ProductPrice> getProductPrices(Product product, String shortName, boolean includeLinked, PricingGroup group) {
        ProductPricePredicate predicate = new ProductPricePredicate(shortName, group);
        List<ProductPrice> prices = this.findPrices(product, predicate);
        ArrayList<ProductPrice> result = new ArrayList<ProductPrice>(prices);
        if (includeLinked && "productPrice.fixedPrice".equals(shortName)) {
            result.addAll(this.findLinkedPrices(product, predicate, Predicates.activeNow()));
        }
        return this.sort(result);
    }

    public List<ProductPrice> getProductPrices(Product product, String shortName, Date date, PricingGroup group) {
        return this.getProductPrices(product, shortName, date, true, group);
    }

    public List<ProductPrice> getProductPrices(Product product, String shortName, Date date, boolean includeLinked, PricingGroup group) {
        ShortNameDatePredicate predicate = new ShortNameDatePredicate(shortName, date, group);
        List<ProductPrice> prices = this.findPrices(product, predicate);
        ArrayList<ProductPrice> result = new ArrayList<ProductPrice>(prices);
        if (includeLinked && "productPrice.fixedPrice".equals(shortName)) {
            result.addAll(this.findLinkedPrices(product, predicate, Predicates.activeAt((Date)date)));
        }
        return this.sort(result);
    }

    public List<ProductPrice> getProductPrices(Product product, String shortName, Date from, Date to, PricingGroup group) {
        return this.getProductPrices(product, shortName, from, to, true, group);
    }

    public List<ProductPrice> getProductPrices(Product product, String shortName, Date from, Date to, boolean includeLinked, PricingGroup group) {
        ShortNameDateRangePredicate predicate = new ShortNameDateRangePredicate(shortName, from, to, group);
        List<ProductPrice> prices = this.findPrices(product, predicate);
        ArrayList<ProductPrice> result = new ArrayList<ProductPrice>(prices);
        if (includeLinked && "productPrice.fixedPrice".equals(shortName)) {
            result.addAll(this.findLinkedPrices(product, predicate, Predicates.active((Date)from, (Date)to)));
        }
        return this.sort(result);
    }

    public BigDecimal getTaxExPrice(BigDecimal cost, BigDecimal markup) {
        BigDecimal price = BigDecimal.ZERO;
        if (cost.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal markupDec = this.getRate(markup);
            price = cost.multiply(BigDecimal.ONE.add(markupDec));
        }
        return price;
    }

    public BigDecimal getTaxExPrice(BigDecimal taxIncPrice, Product product, Party practice) {
        BigDecimal price = taxIncPrice;
        BigDecimal taxRate = this.getTaxRate(product, practice);
        if (taxRate.compareTo(BigDecimal.ZERO) != 0) {
            price = taxIncPrice.divide(BigDecimal.ONE.add(this.getRate(taxRate)), 3, RoundingMode.HALF_UP);
        }
        return price;
    }

    public BigDecimal getTaxIncPrice(BigDecimal taxExPrice, Product product, Party practice, Currency currency) {
        BigDecimal taxRate = this.getTaxRate(product, practice);
        return this.getTaxIncPrice(taxExPrice, taxRate, currency);
    }

    public BigDecimal getTaxIncPrice(BigDecimal taxExPrice, BigDecimal taxRate, Currency currency) {
        BigDecimal price = taxExPrice;
        if (taxRate.compareTo(BigDecimal.ZERO) != 0) {
            price = taxExPrice.multiply(BigDecimal.ONE.add(this.getRate(taxRate)));
        }
        price = currency.roundPrice(price);
        return price;
    }

    public BigDecimal getMarkup(BigDecimal cost, BigDecimal price) {
        BigDecimal markup = BigDecimal.ZERO;
        if (cost.compareTo(BigDecimal.ZERO) != 0 && (markup = price.divide(cost, 3, RoundingMode.HALF_UP).subtract(BigDecimal.ONE).multiply(MathRules.ONE_HUNDRED)).compareTo(BigDecimal.ZERO) < 0) {
            markup = BigDecimal.ZERO;
        }
        return markup;
    }

    public BigDecimal getMaxDiscount(BigDecimal markup) {
        BigDecimal discount = DEFAULT_MAX_DISCOUNT;
        if (markup.compareTo(BigDecimal.ZERO) > 0) {
            discount = markup.divide(MathRules.ONE_HUNDRED.add(markup), 3, RoundingMode.HALF_DOWN).multiply(MathRules.ONE_HUNDRED);
        }
        return discount;
    }

    public List<ProductPrice> updateUnitPrices(Product product, BigDecimal cost, boolean ignoreCostDecrease, Currency currency) {
        BigDecimal roundedCost;
        Date now;
        Predicate<ProductPrice> predicate;
        List<ProductPrice> result = Collections.emptyList();
        IMObjectBean bean = this.service.getBean((IMObject)product);
        List prices = bean.getValues("prices", ProductPrice.class, predicate = arg_0 -> this.lambda$updateUnitPrices$0(now = this.getNow(), ignoreCostDecrease, roundedCost = currency.round(cost), arg_0));
        if (!prices.isEmpty()) {
            result = this.updateUnitPrices(prices, roundedCost, now, product);
        }
        return result;
    }

    public BigDecimal getMaxDiscount(ProductPrice price) {
        IMObjectBean bean = this.service.getBean((IMObject)price);
        BigDecimal result = bean.getBigDecimal("maxDiscount");
        return result == null ? DEFAULT_MAX_DISCOUNT : result;
    }

    public List<Lookup> getPricingGroups(ProductPrice price) {
        IMObjectBean bean = this.service.getBean((IMObject)price);
        return bean.getValues("pricingGroups", Lookup.class);
    }

    public BigDecimal getCostPrice(ProductPrice price) {
        IMObjectBean bean = this.service.getBean((IMObject)price);
        return bean.getBigDecimal("cost", BigDecimal.ZERO);
    }

    public ServiceRatio getServiceRatio(Product product, Entity department, Party location) {
        ServiceRatio result = null;
        Reference productType = this.getProductType(product);
        if (productType != null) {
            if (department != null) {
                result = this.getServiceRatio(productType, department);
            }
            if (result == null) {
                result = this.getServiceRatio(productType, (Entity)location);
            }
        }
        return result;
    }

    public List<ProductPrice> sort(List<ProductPrice> prices) {
        prices.sort(ComparatorUtils.reversedComparator(ProductPriceComparator.INSTANCE));
        return prices;
    }

    public BigDecimal getTaxRate(Product product, Party practice) {
        TaxRules rules = new TaxRules(practice, this.service);
        return rules.getTaxRate(product);
    }

    public ProductPrice copyAndClose(ProductPrice price, Date date) {
        ProductPrice newPrice = this.copy(price, date);
        price.setToDate(date);
        return newPrice;
    }

    public ProductPrice copy(ProductPrice price, Date date) {
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new PriceCopyHandler(), this.service);
        List objects = copier.apply((IMObject)price);
        ProductPrice newPrice = (ProductPrice)objects.get(0);
        newPrice.setFromDate(date);
        newPrice.setToDate(null);
        return newPrice;
    }

    protected Date getNow() {
        return new Date();
    }

    private ServiceRatio getServiceRatio(Reference productType, Entity entity) {
        Predicate predicate;
        ServiceRatio result = null;
        IMObjectBean bean = this.service.getBean((IMObject)entity);
        EntityLink link = (EntityLink)bean.getValue("serviceRatios", EntityLink.class, predicate = Predicates.activeNow().and(Predicates.targetEquals((Reference)productType)));
        if (link != null) {
            IMObjectBean linkBean = this.service.getBean((IMObject)link);
            BigDecimal ratio = linkBean.getBigDecimal("ratio");
            Reference calendar = linkBean.getReference("calendar");
            if (ratio != null && ratio.compareTo(BigDecimal.ONE) != 0) {
                result = new ServiceRatio(ratio, calendar);
            }
        }
        return result;
    }

    private Reference getProductType(Product product) {
        IMObjectBean productBean = this.service.getBean((IMObject)product);
        return productBean.getTargetRef("type");
    }

    private List<ProductPrice> updateUnitPrices(List<ProductPrice> prices, BigDecimal cost, Date closeTime, Product product) {
        ArrayList<ProductPrice> result = new ArrayList<ProductPrice>();
        for (ProductPrice price : prices) {
            ProductPrice updated = this.updateUnitPrice(price, cost, closeTime, product, prices);
            if (updated == null) continue;
            if (updated != price) {
                result.add(price);
            }
            result.add(updated);
        }
        return result;
    }

    private ProductPrice updateUnitPrice(ProductPrice price, BigDecimal cost, Date closeTime, Product product, List<ProductPrice> prices) {
        ProductPrice result = null;
        IMObjectBean priceBean = this.service.getBean((IMObject)price);
        if (!MathRules.equals(priceBean.getBigDecimal("cost", BigDecimal.ZERO), cost)) {
            BigDecimal markup = priceBean.getBigDecimal("markup", MathRules.ONE_HUNDRED);
            BigDecimal taxExPrice = this.getTaxExPrice(cost, markup);
            if (price.isNew()) {
                result = price;
            } else {
                Date toDate = price.getToDate();
                if (toDate == null) {
                    toDate = closeTime;
                    if (price.getFromDate() != null && DateRules.compareTo(price.getFromDate(), toDate) > 0) {
                        toDate = price.getFromDate();
                    }
                }
                if (!this.hasUnitPrice(product, toDate, prices)) {
                    result = this.copyAndClose(price, toDate);
                }
            }
            if (result != null) {
                IMObjectBean bean = this.service.getBean((IMObject)result);
                bean.setValue("cost", (Object)cost);
                result.setPrice(taxExPrice);
            }
        }
        return result;
    }

    private boolean hasUnitPrice(Product product, Date date, List<ProductPrice> exclude) {
        Predicate<ProductPrice> predicate = price -> !exclude.contains(price) && price.isActive() && price.isA("productPrice.unitPrice") && DateRules.between(date, price.getFromDate(), price.getToDate());
        return product.getProductPrices().stream().anyMatch(predicate);
    }

    private BigDecimal getRate(BigDecimal percent) {
        if (percent.compareTo(BigDecimal.ZERO) != 0) {
            return MathRules.divide(percent, MathRules.ONE_HUNDRED, 4);
        }
        return BigDecimal.ZERO;
    }

    private ProductPrice getProductPrice(String shortName, Product product, ProductPricePredicate predicate, Date date) {
        boolean useDefault = "productPrice.fixedPrice".equals(shortName);
        ProductPrice result = this.findPrice(product, predicate, useDefault);
        if (useDefault && (result == null || !this.isDefault(result))) {
            for (Product linked : this.getLinkedProducts(product, date)) {
                ProductPrice price = this.findPrice(linked, predicate, true);
                if (price == null) continue;
                if (this.isDefault(price)) {
                    result = price;
                    break;
                }
                if (result != null) continue;
                result = price;
            }
        }
        return result;
    }

    private List<Product> getLinkedProducts(Product product, Date date) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        List result = bean.hasNode(LINKED) ? bean.getTargets(LINKED, Product.class, Policies.active((Date)date)) : Collections.emptyList();
        return result;
    }

    private ProductPrice findPrice(Product product, ProductPricePredicate predicate, boolean useDefault) {
        ProductPrice result = null;
        ProductPrice fallback = null;
        int fallbackMatch = 0;
        for (ProductPrice price : product.getProductPrices()) {
            int match = predicate.matches(price);
            if (match <= 0) continue;
            if (match == 2 && (!useDefault || this.isDefault(price))) {
                result = price;
                break;
            }
            if (match <= fallbackMatch && (match != fallbackMatch || !useDefault || !this.isDefault(price))) continue;
            fallback = price;
            fallbackMatch = match;
        }
        return result != null ? result : fallback;
    }

    private List<ProductPrice> findPrices(Product product, ProductPricePredicate predicate) {
        List<ProductPrice> result = null;
        for (ProductPrice price : product.getProductPrices()) {
            if (!predicate.test(price)) continue;
            if (result == null) {
                result = new ArrayList<ProductPrice>();
            }
            result.add(price);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<ProductPrice> findLinkedPrices(Product product, ProductPricePredicate price, Predicate<Relationship> active) {
        List<ProductPrice> result = null;
        IMObjectBean bean = this.service.getBean((IMObject)product);
        if (bean.hasNode(LINKED)) {
            for (Product linked : bean.getTargets(LINKED, Product.class, Policies.match((boolean)true, active))) {
                List<ProductPrice> prices = this.findPrices(linked, price);
                if (result == null) {
                    result = new ArrayList<ProductPrice>();
                }
                result.addAll(prices);
            }
        }
        return result != null ? result : Collections.emptyList();
    }

    private boolean isDefault(ProductPrice price) {
        IMObjectBean bean = this.service.getBean((IMObject)price);
        return bean.getBoolean("default");
    }

    private /* synthetic */ boolean lambda$updateUnitPrices$0(Date now, boolean ignoreCostDecrease, BigDecimal roundedCost, ProductPrice price) {
        boolean match;
        boolean bl = match = price.isActive() && price.isA("productPrice.unitPrice") && DateRules.between(now, price.getFromDate(), price.getToDate());
        if (match && ignoreCostDecrease) {
            BigDecimal currentCost = this.getCostPrice(price);
            match = currentCost.compareTo(roundedCost) < 0;
        }
        return match;
    }

    private static class ProductPriceComparator
    implements Comparator<ProductPrice> {
        public static final Comparator<ProductPrice> INSTANCE = new ProductPriceComparator();

        private ProductPriceComparator() {
        }

        @Override
        public int compare(ProductPrice o1, ProductPrice o2) {
            int result = Objects.equals(o1.getToDate(), o2.getToDate()) ? 0 : (o1.getToDate() == null ? 1 : (o2.getToDate() == null ? -1 : DateRules.compareTo(o1.getToDate(), o2.getToDate())));
            if (result == 0 && !Objects.equals(o1.getFromDate(), o2.getFromDate())) {
                result = o1.getFromDate() == null ? 1 : (o2.getFromDate() == null ? -1 : DateRules.compareDates(o1.getFromDate(), o2.getFromDate()));
            }
            return result;
        }
    }

    private class PricePredicate
    extends ShortNameDatePredicate {
        private final BigDecimal price;

        PricePredicate(BigDecimal price, String shortName, Date date, PricingGroup group) {
            super(shortName, date, group);
            this.price = price;
        }

        @Override
        public int matches(ProductPrice other) {
            if (other.getPrice().compareTo(this.price) == 0) {
                return super.matches(other);
            }
            return 0;
        }
    }

    private class ShortNameDateRangePredicate
    extends ProductPricePredicate {
        private final Date from;
        private final Date to;

        ShortNameDateRangePredicate(String shortName, Date from, Date to, PricingGroup group) {
            super(shortName, group);
            this.from = from;
            this.to = to;
        }

        @Override
        public int matches(ProductPrice price) {
            int result = super.matches(price);
            if (result > 0 && !DateRules.intersects(this.from, this.to, price.getFromDate(), price.getToDate())) {
                result = 0;
            }
            return result;
        }
    }

    private class ShortNameDatePredicate
    extends ProductPricePredicate {
        private final Date date;

        ShortNameDatePredicate(String shortName, Date date, PricingGroup group) {
            super(shortName, group);
            this.date = date;
        }

        @Override
        public int matches(ProductPrice price) {
            Date to;
            Date from;
            int result = super.matches(price);
            if (result > 0 && !DateRules.between(this.date, from = price.getFromDate(), to = price.getToDate())) {
                result = 0;
            }
            return result;
        }
    }

    private class ProductPricePredicate
    implements Predicate<ProductPrice> {
        private final String shortName;
        private final PricingGroup group;

        ProductPricePredicate(String shortName, PricingGroup group) {
            this.shortName = shortName;
            this.group = group;
        }

        @Override
        public boolean test(ProductPrice price) {
            return this.matches(price) > 0;
        }

        public int matches(ProductPrice price) {
            int result = 0;
            if (price.isA(this.shortName) && price.isActive()) {
                if (this.group.isAll()) {
                    result = 2;
                } else {
                    IMObjectBean bean = ProductPriceRules.this.service.getBean((IMObject)price);
                    List groups = bean.getValues("pricingGroups", Lookup.class);
                    Lookup lookup = this.group.getGroup();
                    if (lookup == null && groups.isEmpty() || lookup != null && groups.contains(lookup)) {
                        result = 2;
                    } else if (lookup != null && groups.isEmpty() && this.group.useFallback()) {
                        result = 1;
                    }
                }
            }
            return result;
        }
    }
}

