/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import org.openvpms.archetype.rules.util.MappingCopyHandler;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;

class ProductCopyHandler
extends MappingCopyHandler {
    private final Reference product;

    public ProductCopyHandler(Product product) {
        this.product = product.getObjectReference();
        this.setCopy("entity.productDose");
        this.setReference(Entity.class);
    }

    public NodeDescriptor getNode(ArchetypeDescriptor source, NodeDescriptor sourceNode, ArchetypeDescriptor target) {
        boolean isStockLocation = TypeHelper.isA((org.openvpms.component.model.archetype.ArchetypeDescriptor)source, (String)"entityLink.productStockLocation");
        if (isStockLocation && "quantity".equals(sourceNode.getName())) {
            return null;
        }
        return super.getNode(source, sourceNode, target);
    }

    @Override
    protected MappingCopyHandler.Treatment getTreatment(IMObject object) {
        if (this.copy(object)) {
            return MappingCopyHandler.Treatment.COPY;
        }
        if (this.reference(object)) {
            return MappingCopyHandler.Treatment.REFERENCE;
        }
        if (this.exclude(object)) {
            return MappingCopyHandler.Treatment.EXCLUDE;
        }
        return this.getDefaultTreatment();
    }

    @Override
    protected boolean copy(IMObject object) {
        return object.getObjectReference().equals((Object)this.product) || super.copy(object);
    }
}

