/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.util.Collection;
import org.openvpms.component.model.lookup.Lookup;

public class PricingGroup {
    public static final PricingGroup ALL = new PricingGroup();
    public static final PricingGroup NONE = new PricingGroup(null);
    private final boolean allGroups;
    private final Lookup group;
    private final boolean useFallback;

    private PricingGroup() {
        this(null, false, true);
    }

    public PricingGroup(Lookup group) {
        this(group, true);
    }

    public PricingGroup(Lookup group, boolean useFallback) {
        this(group, useFallback, false);
    }

    private PricingGroup(Lookup group, boolean useFallback, boolean allGroups) {
        this.group = group;
        this.useFallback = useFallback;
        this.allGroups = allGroups;
    }

    public Lookup getGroup() {
        return this.group;
    }

    public boolean isAll() {
        return this.allGroups;
    }

    public boolean isNone() {
        return !this.allGroups && this.group == null;
    }

    public boolean useFallback() {
        return this.useFallback;
    }

    public boolean matches(Collection<Lookup> groups) {
        if (this.allGroups) {
            return true;
        }
        if (this.group == null) {
            return groups.isEmpty();
        }
        return groups.isEmpty() && this.useFallback || groups.contains(this.group);
    }
}

