/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class PriceCollector {
    private final ArchetypeService service;
    private final Map<Product, List<ProductPrice>> products = new LinkedHashMap<Product, List<ProductPrice>>();
    private final List<ProductPrice> prices = new ArrayList<ProductPrice>();

    public PriceCollector(ArchetypeService service) {
        this.service = service;
    }

    public void add(Product product, List<ProductPrice> prices) {
        List current = this.products.computeIfAbsent(product, k -> new ArrayList());
        current.addAll(prices);
        this.prices.addAll(prices);
    }

    public List<ProductPrice> getPrices() {
        return this.prices;
    }

    public List<ProductPrice> save() {
        List<IMObject> toSave = this.prepareSave();
        if (!toSave.isEmpty()) {
            this.service.save(toSave);
        }
        return this.prices;
    }

    public List<ProductPrice> deriveValues() {
        for (ProductPrice price : this.prices) {
            this.service.deriveValues((IMObject)price);
        }
        return this.prices;
    }

    public List<IMObject> prepareSave() {
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        for (Map.Entry<Product, List<ProductPrice>> entry : this.products.entrySet()) {
            Product product = entry.getKey();
            boolean saveProduct = false;
            for (ProductPrice price : entry.getValue()) {
                if (price.getProduct() != null) continue;
                product.addProductPrice(price);
                saveProduct = true;
            }
            if (saveProduct) {
                toSave.add((IMObject)product);
                continue;
            }
            toSave.addAll((Collection<IMObject>)entry.getValue());
        }
        return toSave;
    }
}

