/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import java.util.List;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.prefs.PreferencesCopier;
import org.openvpms.archetype.rules.prefs.PreferencesImpl;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

class PreferenceManager {
    private PreferenceManager() {
    }

    public static Preferences getPreferences(Reference party, Reference source, IArchetypeService service) {
        Entity prefs = PreferenceManager.getEntity(party, service);
        if (prefs == null && source != null) {
            prefs = PreferenceManager.getEntity(source, service);
        }
        if (prefs == null) {
            prefs = (Entity)service.create("entity.preferences", Entity.class);
        }
        return new PreferencesImpl(party, source, prefs, service);
    }

    public static Entity getPreferences(Reference party, Reference source, IArchetypeService service, PlatformTransactionManager transactionManager) {
        TransactionTemplate template = new TransactionTemplate(transactionManager);
        Entity result = (Entity)template.execute(status -> {
            Entity sourcePrefs;
            Entity prefs = PreferenceManager.getEntity(party, service);
            if (prefs == null && source != null && (sourcePrefs = PreferenceManager.getEntity(source, service)) != null) {
                prefs = PreferenceManager.copy(party, sourcePrefs, service);
            }
            if (prefs == null) {
                prefs = (Entity)service.create("entity.preferences", Entity.class);
                IMObjectBean bean = service.getBean((IMObject)prefs);
                bean.addTarget("user", party);
                bean.save();
            }
            return prefs;
        });
        return result;
    }

    protected static Entity copy(Reference party, Entity prefs, IArchetypeService service) {
        List<IMObject> objects = PreferencesCopier.copy(prefs, party, service);
        service.save(objects);
        return (Entity)objects.get(0);
    }

    protected static Entity getEntity(Reference party, IArchetypeService service) {
        Entity prefs = null;
        ArchetypeQuery query = new ArchetypeQuery("entity.preferences");
        query.add((IConstraint)Constraints.join((String)"user").add((IConstraint)Constraints.eq((String)"target", (Reference)party)));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        if (iterator.hasNext()) {
            prefs = (Entity)iterator.next();
        }
        return prefs;
    }
}

