/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.practice;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.joda.time.Period;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.event.AsyncListeners;
import org.openvpms.component.system.common.event.Listener;
import org.openvpms.component.system.common.event.Listeners;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class PracticeService
implements DisposableBean {
    private final IArchetypeService service;
    private final PracticeRules rules;
    private final IArchetypeServiceListener listener;
    private final Listeners<Update> listeners;
    private final IArchetypeServiceListener jobListener;
    private final AtomicReference<Boolean> accountRemindersEnabled = new AtomicReference();
    private Party practice;

    public PracticeService(IArchetypeService service, PracticeRules rules, ThreadPoolTaskExecutor executor) {
        this.service = service;
        this.rules = rules;
        this.practice = rules.getPractice();
        this.listener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                PracticeService.this.update((Party)object);
            }
        };
        this.listeners = executor != null ? new AsyncListeners(executor.getThreadPoolExecutor()) : null;
        service.addListener("party.organisationPractice", this.listener);
        this.jobListener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                PracticeService.this.accountRemindersEnabled.set(object.isActive());
            }

            public void removed(IMObject object) {
                PracticeService.this.accountRemindersEnabled.set(null);
            }
        };
        service.addListener("entity.jobAccountReminder", this.jobListener);
    }

    public synchronized Party getPractice() {
        return this.practice;
    }

    public List<Party> getLocations() {
        Party current = this.getPractice();
        return current != null ? this.rules.getLocations(current) : Collections.emptyList();
    }

    public MailServer getMailServer() {
        Entity entity;
        MailServer result = null;
        IMObjectBean bean = this.getBean();
        if (bean != null && (entity = (Entity)bean.getTarget("mailServer", Entity.class, Policies.active())) != null) {
            result = new MailServer(entity, (ArchetypeService)this.service);
        }
        return result;
    }

    public Currency getCurrency() {
        Party current = this.getPractice();
        return current != null ? this.rules.getCurrency(current) : null;
    }

    public Entity getSMS() {
        IMObjectBean bean = this.getBean();
        return bean != null ? (Entity)bean.getTarget("sms", Entity.class) : null;
    }

    public User getServiceUser() {
        Party current = this.getPractice();
        return current != null ? this.rules.getServiceUser(current) : null;
    }

    public Entity getAppointmentSMSTemplate() {
        IMObjectBean bean = this.getBean();
        return bean != null ? (Entity)bean.getTarget("smsAppointment", Entity.class) : null;
    }

    public Period getRecordLockPeriod() {
        Party current = this.getPractice();
        return current != null ? this.rules.getRecordLockPeriod(current) : null;
    }

    public Period getPharmacyOrderDiscontinuePeriod() {
        Party current = this.getPractice();
        return current != null ? this.rules.getPharmacyOrderDiscontinuePeriod(current) : null;
    }

    public char getExportFileFieldSeparator() {
        Party current = this.getPractice();
        return current != null ? this.rules.getExportFileFieldSeparator(current) : (char)',';
    }

    public String getBaseURL() {
        Party current = this.getPractice();
        return current != null ? this.rules.getBaseURL(current) : null;
    }

    public boolean pluginsEnabled() {
        Party current = this.getPractice();
        return current != null && this.rules.pluginsEnabled(current);
    }

    public boolean accountRemindersEnabled() {
        Boolean result = this.accountRemindersEnabled.get();
        if (result == null) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Long.class);
            Root root = query.from(Entity.class, new String[]{"entity.jobAccountReminder"});
            query.select((Selection)root.get("id"));
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
            result = this.service.createQuery(query).getFirstResult() != null;
            if (!this.accountRemindersEnabled.compareAndSet(null, result)) {
                result = this.accountRemindersEnabled.get();
            }
        }
        return result != null && result != false;
    }

    public WeightUnits getDefaultWeightUnits() {
        Party current = this.getPractice();
        return current != null ? this.rules.getDefaultWeightUnits(current) : WeightUnits.KILOGRAMS;
    }

    public void destroy() {
        this.service.removeListener("party.organisationPractice", this.listener);
        this.service.removeListener("entity.jobAccountReminder", this.jobListener);
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public void addListener(Listener<Update> listener) {
        if (this.listeners != null) {
            this.listeners.addListener(listener);
        }
    }

    public void removeListener(Listener<Update> listener) {
        if (this.listeners != null) {
            this.listeners.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Party object) {
        boolean updated = false;
        PracticeService practiceService = this;
        synchronized (practiceService) {
            if (object.isActive() || this.practice == null || this.practice.getId() == object.getId()) {
                updated = true;
                this.practice = object;
            }
        }
        if (updated && this.listeners != null) {
            this.listeners.onEvent((Object)new Update(object));
        }
    }

    protected IMObjectBean getBean() {
        Party result = this.getPractice();
        return result != null ? this.service.getBean((IMObject)result) : null;
    }

    public static class Update {
        private final Party practice;
        private final String user;

        private Update(Party practice) {
            this.practice = practice;
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            this.user = authentication != null ? authentication.getName() : null;
        }

        public Party getPractice() {
            return this.practice;
        }

        public String getUser() {
            return this.user;
        }
    }
}

