/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.practice;

import java.util.Date;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Period;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.archetype.rules.util.PeriodHelper;
import org.openvpms.component.business.service.singleton.SingletonQuery;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

public class PracticeRules {
    private final ArchetypeService service;
    private final Currencies currencies;

    public PracticeRules(ArchetypeService service, Currencies currencies) {
        this.service = service;
        this.currencies = currencies;
    }

    public boolean isActivePractice(Party practice) {
        boolean result = false;
        if (practice.isActive()) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Party.class);
            Root root = query.from(Party.class, new String[]{"party.organisationPractice"});
            query.select((Selection)root.get("id"));
            query.where(new Predicate[]{builder.equal((Expression)root.get("active"), (Object)true), builder.notEqual((Expression)root.get("id"), (Object)practice.getId())});
            if (this.service.createQuery(query).getFirstResult() == null) {
                result = true;
            }
        }
        return result;
    }

    public Party getPractice() {
        return PracticeRules.getPractice(this.service);
    }

    public List<Party> getLocations(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        return bean.getTargets("locations", Party.class, Policies.active());
    }

    public User getServiceUser(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        return (User)bean.getTarget("serviceUser", User.class);
    }

    public Currency getCurrency(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        String code = bean.getString("currency");
        return this.currencies.getCurrency(code);
    }

    public Party getDefaultLocation(Party practice) {
        return (Party)EntityRelationshipHelper.getDefaultTarget((Entity)practice, "locations", this.service);
    }

    public Period getRecordLockPeriod(Party practice) {
        return this.getPeriod(practice, "recordLockPeriod", "recordLockPeriodUnits");
    }

    public Date getEstimateExpiryDate(Date startDate, Party practice) {
        Date result = null;
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        int period = bean.getInt("estimateExpiryPeriod");
        String units = bean.getString("estimateExpiryUnits");
        if (period > 0 && !StringUtils.isEmpty((CharSequence)units)) {
            result = DateRules.getDate(startDate, period, DateUnits.valueOf(units));
        }
        return result;
    }

    public Date getPrescriptionExpiryDate(Date startDate, Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        int period = bean.getInt("prescriptionExpiryPeriod");
        String units = bean.getString("prescriptionExpiryUnits");
        if (!StringUtils.isEmpty((CharSequence)units)) {
            return DateRules.getDate(startDate, period, DateUnits.valueOf(units));
        }
        return startDate;
    }

    public char getExportFileFieldSeparator(Party practice) {
        char separator = ',';
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        if ("TAB".equals(bean.getString("fileExportFormat"))) {
            separator = '\t';
        }
        return separator;
    }

    public boolean isSMSEnabled(Party practice) {
        boolean enabled = false;
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        Reference ref = bean.getTargetRef("sms");
        if (ref != null) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Entity.class);
            Root root = query.from(Entity.class, new String[]{ref.getArchetype()});
            query.select((Selection)root.get("id"));
            query.where(new Predicate[]{builder.equal((Expression)root.get("id"), (Object)ref.getId()), builder.equal((Expression)root.get("active"), (Object)true)});
            enabled = this.service.createQuery(query).getFirstResult() != null;
        }
        return enabled;
    }

    public boolean useLocationProducts(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        return bean.getBoolean("useLocationProducts");
    }

    public boolean ignoreListPriceDecreases(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        return bean.getBoolean("ignoreListPriceDecreases");
    }

    public boolean departmentsEnabled(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        return bean.getBoolean("departments");
    }

    public boolean isOrderingRestricted(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        return bean.getBoolean("restrictOrdering");
    }

    public Period getPharmacyOrderDiscontinuePeriod(Party practice) {
        return this.getPeriod(practice, "pharmacyOrderDiscontinuePeriod", "pharmacyOrderDiscontinuePeriodUnits");
    }

    public String getBaseURL(Party practice) {
        return this.service.getBean((IMObject)practice).getString("baseUrl");
    }

    public boolean pluginsEnabled(Party practice) {
        return this.service.getBean((IMObject)practice).getBoolean("enablePlugins");
    }

    public WeightUnits getDefaultWeightUnits(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        String units = bean.getString("defaultWeightUnits", WeightUnits.KILOGRAMS.toString());
        return WeightUnits.valueOf((String)units);
    }

    public static Party getPractice(ArchetypeService service) {
        return (Party)new SingletonQuery(service).get("party.organisationPractice", Party.class);
    }

    private Period getPeriod(Party practice, String periodName, String unitsName) {
        return PeriodHelper.getPeriod(this.service.getBean((IMObject)practice), periodName, unitsName);
    }
}

