/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ObjectSet;

public class ReminderEvent
extends ObjectSet {
    private static final String REMINDER = "reminder";
    private static final String ITEM = "item";
    private static final String PATIENT = "patient";
    private static final String CUSTOMER = "customer";
    private static final String REMINDER_TYPE = "reminderType";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String REMINDER_COUNT = "reminderCount";
    private static final String PRODUCT = "product";
    private static final String CLINICIAN = "clinician";
    private static final String CONTACT = "contact";
    private static final String LOCATION = "location";
    private static final String DOCUMENT_TEMPLATE = "documentTemplate";

    public ReminderEvent(ObjectSet set) {
        this((Act)set.get(REMINDER), (Act)set.get(ITEM), (Party)set.get(PATIENT), (Party)set.get(CUSTOMER));
    }

    public ReminderEvent(Act reminder, Act item, Party patient, Party customer) {
        this.set(REMINDER, reminder);
        this.set(ITEM, item);
        this.set(PATIENT, patient);
        this.set(CUSTOMER, customer);
        this.set(START_TIME, reminder.getActivityStartTime());
        this.set(END_TIME, reminder.getActivityEndTime());
    }

    public ReminderEvent(Act reminder, Act item, Party patient, Party customer, Contact contact) {
        this(reminder, item, patient, customer);
        this.setContact(contact);
    }

    public Act getReminder() {
        return (Act)this.get(REMINDER);
    }

    public Act getItem() {
        return (Act)this.get(ITEM);
    }

    public Entity getReminderType() {
        return this.safeGet(REMINDER_TYPE, null);
    }

    public void setReminderType(Entity reminderType) {
        this.set(REMINDER_TYPE, reminderType);
    }

    public Product getProduct() {
        return this.safeGet(PRODUCT, null);
    }

    public void setProduct(Product product) {
        this.set(PRODUCT, product);
    }

    public User getClinician() {
        return this.safeGet(CLINICIAN, null);
    }

    public void setClinician(User clinician) {
        this.set(CLINICIAN, clinician);
    }

    public Party getPatient() {
        return (Party)this.get(PATIENT);
    }

    public Party getCustomer() {
        return (Party)this.get(CUSTOMER);
    }

    public Contact getContact() {
        return this.safeGet(CONTACT, null);
    }

    public void setContact(Contact contact) {
        this.set(CONTACT, contact);
    }

    public Entity getDocumentTemplate() {
        return this.safeGet(DOCUMENT_TEMPLATE, null);
    }

    public int getReminderCount() {
        return this.safeGet(REMINDER_COUNT, 0);
    }

    public void setReminderCount(int count) {
        this.set(REMINDER_COUNT, count);
    }

    public Party getLocation() {
        return (Party)this.get(LOCATION);
    }

    public void setLocation(Party location) {
        this.set(LOCATION, location);
    }

    private <T> T safeGet(String name, T defaultValue) {
        return (T)(this.exists(name) ? this.get(name) : defaultValue);
    }
}

