/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.PushbackIterator;
import org.openvpms.archetype.rules.patient.reminder.PagedReminderItemIterator;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderGroupingPolicy;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.patient.reminder.Reminders;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;

public class GroupingReminderIterator
implements Iterator<Reminders> {
    private final ReminderTypes reminderTypes;
    private final ReminderGroupingPolicy groupByCustomer;
    private final ReminderGroupingPolicy groupByPatient;
    private final IArchetypeService service;
    private final PagedReminderItemIterator pagedIterator;
    private final PushbackIterator<ObjectSet> pushbackIterator;
    private List<ReminderEvent> remindersByCustomer;
    private List<ReminderEvent> remindersByPatient;
    private List<ReminderEvent> ungroupedReminders;
    private Reminders next;

    public GroupingReminderIterator(ReminderItemQueryFactory factory, ReminderTypes reminderTypes, int pageSize, ReminderGroupingPolicy groupByCustomer, ReminderGroupingPolicy groupByPatient, IArchetypeService service) {
        this.service = service;
        this.reminderTypes = reminderTypes;
        this.groupByCustomer = groupByCustomer;
        this.groupByPatient = groupByPatient;
        this.pagedIterator = new PagedReminderItemIterator(factory, pageSize, service);
        this.pushbackIterator = new PushbackIterator((Iterator)((Object)this.pagedIterator));
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.getNext();
        }
        return this.next != null;
    }

    @Override
    public Reminders next() {
        if (this.next == null) {
            this.next = this.getNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
        }
        Reminders result = this.next;
        this.next = null;
        return result;
    }

    public void updated() {
        this.pagedIterator.updated();
    }

    private Reminders getNext() {
        Reminders result = this.getNextGroup();
        if (result == null) {
            GroupState state = new GroupState();
            while (this.pushbackIterator.hasNext()) {
                ObjectSet set = (ObjectSet)this.pushbackIterator.next();
                boolean processed = this.process(set, state);
                if (processed) continue;
                this.pushbackIterator.pushback((Object)set);
                break;
            }
            result = this.getNextGroup();
        }
        return result;
    }

    private boolean process(ObjectSet set, GroupState state) {
        Party customer;
        boolean processed = false;
        Act item = (Act)set.get("item");
        String archetype = item.getArchetype();
        if (state.sameArchetype(archetype) && state.sameCustomer(customer = (Party)set.get("customer"))) {
            ReminderType.GroupBy groupBy = this.getGroupBy(set);
            if (groupBy == ReminderType.GroupBy.NONE || groupBy == ReminderType.GroupBy.CUSTOMER && !this.groupByCustomer.group(archetype) || groupBy == ReminderType.GroupBy.PATIENT && !this.groupByPatient.group(archetype)) {
                processed = true;
                this.ungroupedReminders = this.add(this.ungroupedReminders, set);
            } else if (groupBy == ReminderType.GroupBy.CUSTOMER) {
                processed = true;
                this.remindersByCustomer = this.add(this.remindersByCustomer, set);
            } else {
                Party patient = (Party)set.get("patient");
                if (state.samePatient(patient)) {
                    processed = true;
                    this.remindersByPatient = this.add(this.remindersByPatient, set);
                }
            }
        }
        return processed;
    }

    private ReminderType.GroupBy getGroupBy(ObjectSet set) {
        Act reminder = (Act)set.get("reminder");
        IMObjectBean bean = this.service.getBean((IMObject)reminder);
        ReminderType type = this.reminderTypes.get(bean.getTargetRef("reminderType"));
        return type != null ? type.getGroupBy() : ReminderType.GroupBy.NONE;
    }

    private Reminders getNextGroup() {
        Reminders result = null;
        if (this.remindersByPatient != null) {
            result = new Reminders(this.remindersByPatient, ReminderType.GroupBy.PATIENT);
            this.remindersByPatient = null;
        } else if (this.remindersByCustomer != null) {
            result = new Reminders(this.remindersByCustomer, ReminderType.GroupBy.CUSTOMER);
            this.remindersByCustomer = null;
        } else if (this.ungroupedReminders != null) {
            if (this.ungroupedReminders.size() > 1) {
                result = new Reminders(this.ungroupedReminders.remove(0));
            } else {
                result = new Reminders(this.ungroupedReminders, ReminderType.GroupBy.NONE);
                this.ungroupedReminders = null;
            }
        }
        return result;
    }

    private List<ReminderEvent> add(List<ReminderEvent> list, ObjectSet set) {
        if (list == null) {
            list = new ArrayList<ReminderEvent>();
        }
        list.add(new ReminderEvent(set));
        return list;
    }

    private static class GroupState {
        String lastArchetype = null;
        Party lastCustomer = null;
        Party lastPatient = null;

        private GroupState() {
        }

        boolean sameArchetype(String archetype) {
            boolean result = false;
            if (this.lastArchetype == null || this.lastArchetype.equals(archetype)) {
                this.lastArchetype = archetype;
                result = true;
            }
            return result;
        }

        boolean sameCustomer(Party customer) {
            boolean result = false;
            if (this.lastCustomer == null || customer.equals(this.lastCustomer)) {
                this.lastCustomer = customer;
                result = true;
            }
            return result;
        }

        public boolean samePatient(Party patient) {
            boolean result = false;
            if (this.lastPatient == null || this.lastPatient.equals(patient)) {
                this.lastPatient = patient;
                result = true;
            }
            return result;
        }
    }
}

