/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openvpms.archetype.rules.patient.ClinicalEventHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.BoardingHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class PatientHistoryChanges {
    private final Reference location;
    private final ArchetypeService service;
    private final Map<Reference, Act> events = new HashMap<Reference, Act>();
    private final Map<Reference, Boolean> boarding = new HashMap<Reference, Boolean>();
    private final Map<Reference, List<Act>> eventsByPatient = new HashMap<Reference, List<Act>>();
    private final Map<Reference, Act> toSave = new HashMap<Reference, Act>();
    private final Set<Reference> newEvents = new HashSet<Reference>();
    private final Set<IMObject> toRemove = new HashSet<IMObject>();
    private static final String EVENT = "event";

    public PatientHistoryChanges(Party location, ArchetypeService service) {
        this(location != null ? location.getObjectReference() : null, service);
    }

    public PatientHistoryChanges(Reference location, ArchetypeService service) {
        this.location = location;
        this.service = service;
    }

    public Act getEvent(Reference reference) {
        Act event = null;
        if (reference != null && (event = this.events.get(reference)) == null && (event = (Act)this.service.get(reference, Act.class)) != null) {
            this.events.put(reference, event);
            Reference patient = this.getPatient(event);
            if (patient != null) {
                List list = this.eventsByPatient.computeIfAbsent(patient, k -> new ArrayList());
                list.add(event);
                this.sortEvents(list);
            }
        }
        return event;
    }

    public Reference getPatient(Act event) {
        IMObjectBean bean = this.service.getBean((IMObject)event);
        return this.getPatient(bean);
    }

    public List<Act> getEvents(Reference patient) {
        return this.eventsByPatient.get(patient);
    }

    public List<Act> getEvents() {
        return this.eventsByPatient.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void addEvent(Act event) {
        Reference ref = event.getObjectReference();
        if (this.events.putIfAbsent(ref, event) == null) {
            Reference patient;
            if (event.isNew()) {
                this.newEvents.add(ref);
            }
            IMObjectBean bean = this.service.getBean((IMObject)event);
            if (event.isNew()) {
                if (this.location != null && bean.getTargetRef("location") == null) {
                    bean.setTarget("location", this.location);
                }
                this.toSave.put(ref, event);
            }
            if ((patient = this.getPatient(bean)) != null) {
                List acts = this.eventsByPatient.computeIfAbsent(patient, k -> new ArrayList());
                acts.add(event);
                this.sortEvents(acts);
            }
        }
    }

    public Act getLinkedEvent(Act act) {
        Reference ref = this.getLinkedEventRef(act);
        return this.getEvent(ref);
    }

    public Reference getLinkedEventRef(Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.hasNode(EVENT) ? bean.getSourceRef(EVENT) : null;
    }

    public void addToEvent(Act event, List<Act> acts) {
        this.addEvent(event);
        for (Act act : acts) {
            if (this.hasRelationship(act)) continue;
            this.addRelationship(event, act);
        }
    }

    public void addToEvents(List<Act> acts, Date startTime) {
        Map<Reference, List<Act>> map = PatientHistoryChanges.getByPatient(acts, this.service);
        for (Map.Entry<Reference, List<Act>> entry : map.entrySet()) {
            Reference patient = entry.getKey();
            ArrayList<Act> unlinked = new ArrayList<Act>();
            for (Act act : entry.getValue()) {
                Act existingEvent = this.getLinkedEvent(act);
                if (existingEvent != null) {
                    if (Objects.equals(this.getPatient(existingEvent), patient)) continue;
                    this.removeRelationship(existingEvent, act);
                    unlinked.add(act);
                    continue;
                }
                unlinked.add(act);
            }
            if (unlinked.isEmpty()) continue;
            Act event = this.getEventForAddition(patient, startTime, this.getClinician(unlinked), this.location);
            this.addToEvent(event, acts);
        }
    }

    public void addRelationship(Act event, Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)event);
        String node = this.getRelationshipNode(act);
        ActRelationship relationship = (ActRelationship)bean.addTarget(node, (IMObject)act);
        act.addActRelationship(relationship);
        this.changed(event);
        this.changed(act);
    }

    public void removeRelationship(Act event, Act act) {
        String node;
        IMObjectBean bean = this.service.getBean((IMObject)event);
        ActRelationship relationship = (ActRelationship)bean.getValue(node = this.getRelationshipNode(act), ActRelationship.class, Predicates.targetEquals((IMObject)act));
        if (relationship != null) {
            event.removeSourceActRelationship(relationship);
            act.removeTargetActRelationship(relationship);
            this.changed(event);
            this.changed(act);
        }
    }

    public void removeRelationship(Act act) {
        Act event;
        ActRelationship relationship;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (bean.hasNode(EVENT) && (relationship = (ActRelationship)bean.getValue(EVENT, ActRelationship.class, Predicates.targetEquals((IMObject)act))) != null && (event = this.getEvent(relationship.getSource())) != null) {
            this.removeRelationship(event, act);
        }
    }

    public void addItemDocument(FinancialAct item, Act document) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        ActRelationship relationship = (ActRelationship)bean.addTarget("documents", (IMObject)document);
        document.addActRelationship(relationship);
        this.changed((Act)item);
        this.changed(document);
    }

    public void removeItemDocument(FinancialAct item, Act document) {
        this.changed(document);
        this.changed((Act)item);
        this.toRemove.add((IMObject)document);
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        ActRelationship r = (ActRelationship)itemBean.getValue("documents", ActRelationship.class, Predicates.targetEquals((IMObject)document));
        item.removeActRelationship(r);
        document.removeActRelationship(r);
        this.removeRelationship(document);
    }

    public boolean hasRelationship(Act act) {
        return this.getLinkedEventRef(act) != null;
    }

    public boolean isNew(Act event) {
        return this.newEvents.contains(event.getObjectReference());
    }

    public void complete(Date endTime) {
        for (Act event : this.events.values()) {
            if (this.toRemove.contains(event)) continue;
            event.setStatus("COMPLETED");
            event.setActivityEndTime(endTime);
            this.changed(event);
        }
    }

    public void save() {
        if (!this.toSave.isEmpty()) {
            this.service.save(this.toSave.values());
        }
        if (!this.toRemove.isEmpty()) {
            this.service.save(this.toRemove);
            for (IMObject object : this.toRemove) {
                this.service.remove(object);
            }
        }
    }

    public IMObject getObject(Reference ref) {
        Object result = null;
        if (ref != null && (result = ref.isA("act.patientClinicalEvent") ? this.getEvent(ref) : (IMObject)this.toSave.get(ref)) == null) {
            result = this.service.get(ref);
        }
        return result;
    }

    public boolean isBoarding(Act act) {
        Reference ref = act.getObjectReference();
        return this.boarding.computeIfAbsent(ref, reference -> {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            Act appointment = (Act)bean.getSource("appointment", Act.class);
            return appointment != null && BoardingHelper.isBoardingAppointment(appointment, this.service);
        });
    }

    public Act getEventForAddition(Reference patient, Date timestamp, Reference clinician, Reference location) {
        Date now;
        Act result = this.getExistingEventForAddition(patient, timestamp, location);
        if (result == null && timestamp.after(now = new Date())) {
            if (DateRules.getDate(timestamp).compareTo(DateRules.getNextDate(now)) >= 0) {
                result = this.getExistingEventForAddition(patient, now, location);
            }
            timestamp = now;
        }
        if (result == null) {
            result = ClinicalEventHelper.createEvent(patient, timestamp, clinician, location, this.service);
            this.addEvent(result);
        }
        return result;
    }

    public Act getClosestEvent(Date timestamp, Reference location, List<Act> events) {
        Date lowerBound = DateRules.getDate(timestamp);
        Date upperBound = DateRules.getNextDate(lowerBound);
        ArrayList<Act> intersecting = new ArrayList<Act>();
        for (Act event : events) {
            if (!DateRules.intersects(event.getActivityStartTime(), event.getActivityEndTime(), lowerBound, upperBound)) continue;
            intersecting.add(event);
        }
        return ClinicalEventHelper.getEvent(timestamp, location, intersecting, this.service);
    }

    protected boolean canAddToEvent(Act event, Date startTime) {
        boolean result = true;
        Date startDate = DateRules.getDate(startTime);
        Date eventStart = DateRules.getDate(event.getActivityStartTime());
        Date eventEnd = DateRules.getDate(event.getActivityEndTime());
        if ("IN_PROGRESS".equals(event.getStatus())) {
            Date date;
            if (!this.isBoarding(event) && eventStart.before(date = DateRules.getDate(startDate, -1, DateUnits.WEEKS))) {
                result = false;
            }
        } else if (startDate.before(eventStart) || eventEnd != null && startDate.after(eventEnd) || eventEnd == null && startDate.after(eventStart)) {
            result = false;
        }
        return result;
    }

    protected static Map<Reference, List<Act>> getByPatient(List<Act> acts, ArchetypeService service) {
        HashMap<Reference, List<Act>> result = new HashMap<Reference, List<Act>>();
        for (Act act : acts) {
            IMObjectBean bean = service.getBean((IMObject)act);
            Reference patient = bean.getTargetRef("patient");
            if (patient == null) continue;
            List list = result.computeIfAbsent(patient, s -> new ArrayList());
            list.add(act);
            result.put(patient, list);
        }
        return result;
    }

    private Act getExistingEventForAddition(Reference patient, Date timestamp, Reference location) {
        Act result = null;
        List<Act> events = this.getEvents(patient);
        if (events != null) {
            result = this.getClosestEvent(timestamp, location, events);
        }
        if (result == null && (result = ClinicalEventHelper.getEvent(patient, timestamp, location, this.service)) != null) {
            this.addEvent(result);
        }
        if (result != null && !this.canAddToEvent(result, timestamp)) {
            result = null;
        }
        return result;
    }

    private Reference getClinician(Collection<Act> acts) {
        for (Act act : acts) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            Reference clinician = bean.getTargetRef("clinician");
            if (clinician == null) continue;
            return clinician;
        }
        return null;
    }

    private String getRelationshipNode(Act act) {
        return act.isA("act.customerAccountInvoiceItem") ? "chargeItems" : "items";
    }

    private void sortEvents(List<Act> events) {
        if (events.size() > 1) {
            events.sort((o1, o2) -> DateRules.compareTo(o1.getActivityStartTime(), o2.getActivityStartTime()));
        }
    }

    private Reference getPatient(IMObjectBean bean) {
        return bean.getTargetRef("patient");
    }

    private void changed(Act act) {
        this.toSave.put(act.getObjectReference(), act);
    }
}

