/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import org.openvpms.archetype.i18n.time.CompositeDurationFormatter;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.i18n.time.DurationFormatter;
import org.openvpms.archetype.i18n.time.LookupDateDurationFormatter;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class PatientAgeFormatter
implements DurationFormatter {
    private final PracticeRules rules;
    private final LookupService lookups;
    private final ArchetypeService service;
    private DurationFormatter formatter;
    private static final String NO_BIRTHDATE;
    private static final String FUTURE_BIRTHDATE;

    public PatientAgeFormatter(LookupService lookups, PracticeRules rules, ArchetypeService service) {
        this.lookups = lookups;
        this.rules = rules;
        this.service = service;
        this.init();
    }

    public String format(Date birthDate) {
        return this.format(birthDate, new Date());
    }

    @Override
    public String format(Date from, Date to) {
        String result = from != null && to != null ? (to.getTime() >= from.getTime() ? this.getFormatter().format(from, to) : FUTURE_BIRTHDATE) : NO_BIRTHDATE;
        return result;
    }

    protected synchronized DurationFormatter getFormatter() {
        if (this.formatter == null) {
            this.init();
        }
        return this.formatter;
    }

    protected DurationFormatter createDefaultFormatter() {
        CompositeDurationFormatter result = new CompositeDurationFormatter();
        result.add(7, DateUnits.DAYS, DateDurationFormatter.DAY);
        result.add(90, DateUnits.DAYS, DateDurationFormatter.WEEK);
        result.add(23, DateUnits.MONTHS, DateDurationFormatter.MONTH);
        result.add(2, DateUnits.YEARS, DateDurationFormatter.YEAR);
        return result;
    }

    protected synchronized void refresh() {
        this.formatter = null;
    }

    private synchronized void init() {
        Lookup lookup;
        IMObjectBean bean;
        String code;
        Party practice = this.rules.getPractice();
        if (practice != null && (code = (bean = this.service.getBean((IMObject)practice)).getString("patientAgeFormat")) != null && (lookup = this.lookups.getLookup("lookup.durationformats", code)) != null) {
            this.formatter = new LookupDateDurationFormatter(lookup, this.lookups, this.service);
        }
        if (this.formatter == null) {
            this.formatter = this.createDefaultFormatter();
        }
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle(PatientAgeFormatter.class.getName(), Locale.getDefault());
        NO_BIRTHDATE = bundle.getString("noBirthdate");
        FUTURE_BIRTHDATE = bundle.getString("futureBirthdate");
    }
}

