/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.util.Arrays;
import java.util.List;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.party.Contact;

public class PurposeMatcher
extends ContactMatcher {
    private final List<String> purposes;
    private final boolean exact;
    private String exclusion;

    public PurposeMatcher(String shortName, String purpose, IMObjectBeanFactory factory) {
        this(shortName, purpose, true, factory);
    }

    public PurposeMatcher(String shortName, String purpose, boolean exact, IMObjectBeanFactory factory) {
        this(new String[]{shortName}, purpose, exact, factory);
    }

    public PurposeMatcher(String[] shortNames, String purpose, boolean exact, IMObjectBeanFactory factory) {
        String[] stringArray;
        if (purpose != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = purpose;
        } else {
            stringArray = new String[]{};
        }
        this(shortNames, exact, factory, stringArray);
    }

    public PurposeMatcher(String shortName, boolean exact, IMObjectBeanFactory factory, String ... purposes) {
        this(new String[]{shortName}, exact, factory, purposes);
    }

    public PurposeMatcher(String[] shortNames, boolean exact, IMObjectBeanFactory factory, String ... purposes) {
        super(shortNames, factory);
        this.exact = exact;
        this.purposes = Arrays.asList(purposes);
    }

    public void setExclusion(String exclusion) {
        this.exclusion = exclusion;
    }

    @Override
    public boolean matches(Contact contact) {
        return super.matches(contact) && !this.excluded(contact) && this.matchesPurpose(contact);
    }

    public static boolean hasContactPurpose(Contact contact, String purpose) {
        return contact.getClassifications().stream().anyMatch(lookup -> lookup.isA("lookup.contactPurpose") && lookup.getCode().equals(purpose));
    }

    public static boolean hasNoContactPurpose(Contact contact) {
        return contact.getClassifications().stream().noneMatch(lookup -> lookup.isA("lookup.contactPurpose"));
    }

    protected boolean excluded(Contact contact) {
        return this.exclusion != null && PurposeMatcher.hasContactPurpose(contact, this.exclusion);
    }

    protected boolean matchesPurpose(Contact contact) {
        boolean best = false;
        boolean preferred = this.isPreferred(contact);
        if (!this.purposes.isEmpty()) {
            best = this.exact ? this.exactPurposeMatch(contact, preferred) : this.partialPurposeMatch(contact, preferred);
        } else if (preferred) {
            this.setMatch(1, contact);
            best = true;
        } else {
            this.setMatch(2, contact);
        }
        return best;
    }

    private boolean exactPurposeMatch(Contact contact, boolean preferred) {
        boolean best = false;
        int priority = this.purposes.size();
        int i = 0;
        for (String purpose : this.purposes) {
            if (!PurposeMatcher.hasContactPurpose(contact, purpose)) continue;
            ++i;
        }
        if (i == priority && preferred) {
            this.setMatch(0, contact);
            best = true;
        } else if (i == priority) {
            this.setMatch(1, contact);
        }
        return best;
    }

    private boolean partialPurposeMatch(Contact contact, boolean preferred) {
        boolean best = false;
        int priority = this.purposes.size();
        int i = 0;
        for (String purpose : this.purposes) {
            if (!PurposeMatcher.hasContactPurpose(contact, purpose)) continue;
            ++i;
        }
        if (i == priority && preferred) {
            this.setMatch(0, contact);
            best = true;
        } else if (i == priority) {
            this.setMatch(1, contact);
        } else if (i > 0 && !preferred) {
            this.setMatch(priority - i + 2, contact);
        } else if (i > 0) {
            this.setMatch(priority - i + 1, contact);
        } else if (i == 0 && !preferred) {
            this.setMatch(priority + 2, contact);
        } else if (i == 0) {
            this.setMatch(priority + 1, contact);
        }
        return best;
    }
}

