/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.EnumSet;
import org.openvpms.archetype.rules.math.CurrencyException;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;

public class Currency {
    private final java.util.Currency ccy;
    private final RoundingMode roundingMode;
    private final BigDecimal minDenomination;
    private final BigDecimal minPrice;
    private static final BigDecimal POS_HALF = new BigDecimal("0.5");
    private static final BigDecimal NEG_HALF = new BigDecimal("-0.5");
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);

    public Currency(Lookup lookup, IArchetypeService service) {
        String code = lookup.getCode();
        this.ccy = java.util.Currency.getInstance(code);
        if (this.ccy == null) {
            throw new CurrencyException(CurrencyException.ErrorCode.InvalidCurrencyCode, code);
        }
        IMObjectBean bean = service.getBean((IMObject)lookup);
        String mode = bean.getString("roundingMode");
        this.roundingMode = RoundingMode.valueOf(mode);
        this.minDenomination = bean.getBigDecimal("minDenomination", BigDecimal.ZERO);
        this.minPrice = bean.getBigDecimal("minPrice", BigDecimal.ZERO);
    }

    public Currency(java.util.Currency currency, RoundingMode roundingMode) {
        this(currency, roundingMode, Currency.getRoundingAmount(currency.getDefaultFractionDigits()));
    }

    public Currency(java.util.Currency currency, RoundingMode roundingMode, BigDecimal minDenomination) {
        this(currency, roundingMode, minDenomination, Currency.getRoundingAmount(currency.getDefaultFractionDigits()));
    }

    public Currency(java.util.Currency currency, RoundingMode roundingMode, BigDecimal minDenomination, BigDecimal minPrice) {
        EnumSet<RoundingMode> modes = EnumSet.of(RoundingMode.HALF_UP, RoundingMode.HALF_DOWN, RoundingMode.HALF_EVEN);
        if (!modes.contains((Object)roundingMode)) {
            throw new CurrencyException(CurrencyException.ErrorCode.InvalidRoundingMode, new Object[]{roundingMode, currency.getCurrencyCode()});
        }
        this.ccy = currency;
        this.roundingMode = roundingMode;
        this.minDenomination = minDenomination;
        this.minPrice = minPrice;
    }

    public String getCode() {
        return this.ccy.getCurrencyCode();
    }

    public int getDefaultFractionDigits() {
        return this.ccy.getDefaultFractionDigits();
    }

    public BigDecimal getDefaultRoundingAmount() {
        return Currency.getRoundingAmount(this.getDefaultFractionDigits());
    }

    public BigDecimal round(BigDecimal value) {
        int digits = this.getDefaultFractionDigits();
        return digits != -1 ? value.setScale(digits, this.roundingMode) : value;
    }

    public BigDecimal roundCash(BigDecimal value) {
        return this.roundTo(value, this.minDenomination);
    }

    public BigDecimal roundPrice(BigDecimal price) {
        BigDecimal abs = price.abs();
        BigDecimal result = !MathRules.isZero(price) && abs.compareTo(this.minPrice) <= 0 ? this.minPrice : this.roundTo(abs, this.minPrice);
        if (price.signum() != result.signum()) {
            result = result.negate();
        }
        return result;
    }

    public BigDecimal getMinimumDenomination() {
        return this.minDenomination;
    }

    public BigDecimal getMinimumPrice() {
        return this.minPrice;
    }

    protected BigDecimal roundTo(BigDecimal value, BigDecimal minimum) {
        if (minimum.compareTo(BigDecimal.ZERO) == 0) {
            return this.round(value);
        }
        BigDecimal temp = value.divide(minimum);
        BigInteger intPart = temp.toBigInteger();
        value = new BigDecimal(intPart).multiply(minimum);
        BigInteger intTemp = temp.add(this.getHalf(value)).toBigInteger();
        if (temp.subtract(new BigDecimal(intPart)).compareTo(POS_HALF) == 0) {
            BigDecimal div2;
            if (this.roundingMode == RoundingMode.HALF_DOWN) {
                intTemp = intTemp.subtract(BigInteger.valueOf(value.signum()));
            } else if (this.roundingMode == RoundingMode.HALF_EVEN && (div2 = new BigDecimal(intTemp).divide(TWO)).compareTo(new BigDecimal(div2.toBigInteger())) != 0) {
                intTemp = intTemp.subtract(BigInteger.valueOf(value.signum()));
            }
        }
        value = new BigDecimal(intTemp).multiply(minimum);
        return value;
    }

    private BigDecimal getHalf(BigDecimal value) {
        return value.signum() != -1 ? POS_HALF : NEG_HALF;
    }

    private static BigDecimal getRoundingAmount(int digits) {
        if (digits < 0) {
            digits = 2;
        }
        return BigDecimal.ONE.movePointLeft(digits);
    }
}

