/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.rules.finance.till.TillRuleException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

class TillHelper {
    private static final String AMOUNT = "amount";

    private TillHelper() {
    }

    public static FinancialAct createTillBalance(Entity till, IArchetypeService service) {
        FinancialAct act = (FinancialAct)service.create("act.tillBalance", FinancialAct.class);
        IMObjectBean bean = service.getBean((IMObject)act);
        act.setStatus("UNCLEARED");
        bean.setTarget("till", (IMObject)till);
        IMObjectBean tillBean = service.getBean((IMObject)till);
        BigDecimal tillCashFloat = tillBean.getBigDecimal("tillFloat", BigDecimal.ZERO);
        bean.setValue("cashFloat", (Object)tillCashFloat);
        return act;
    }

    public static Reference getTillRef(Act act, IArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)act);
        Reference ref = bean.getTargetRef("till");
        if (ref == null) {
            throw new TillRuleException(TillRuleException.ErrorCode.MissingTill, act.getId());
        }
        return ref;
    }

    public static Entity getTill(Act act, IArchetypeService service) {
        Entity till = (Entity)service.get(TillHelper.getTillRef(act, service));
        if (till == null) {
            throw new TillRuleException(TillRuleException.ErrorCode.MissingTill, act.getId());
        }
        return till;
    }

    public static boolean updateBalance(IMObjectBean bean, IArchetypeService service) {
        BigDecimal total;
        boolean changed = false;
        ActCalculator calc = new ActCalculator((ArchetypeService)service);
        BigDecimal current = bean.getBigDecimal(AMOUNT, BigDecimal.ZERO);
        if (current.compareTo(total = calc.sum((Act)bean.getObject(), "items", AMOUNT)) != 0) {
            bean.setValue(AMOUNT, (Object)total);
            changed = true;
        }
        return changed;
    }

    public static FinancialAct getUnclearedTillBalance(Entity till, IArchetypeService service) {
        return TillHelper.getUnclearedTillBalance(till.getObjectReference(), service);
    }

    public static FinancialAct getUnclearedTillBalance(Reference till, IArchetypeService service) {
        ArchetypeQuery query = new ArchetypeQuery("act.tillBalance", false, true);
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"UNCLEARED")).add((IConstraint)Constraints.join((String)"till").add((IConstraint)Constraints.eq((String)"entity", (Reference)till)));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (FinancialAct)iterator.next() : null;
    }
}

