/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.util.Date;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.EndOfPeriodProcessor;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.BlockingExecutor;

public class StatementService {
    private final IArchetypeRuleService service;
    private final CustomerAccountRules accountRules;
    private final LaboratoryRules laboratoryRules;
    private final PracticeService practiceService;
    private final BlockingExecutor<Long> endPeriodExecutor = new BlockingExecutor();

    public StatementService(IArchetypeRuleService service, CustomerAccountRules accountRules, LaboratoryRules laboratoryRules, PracticeService practiceService) {
        this.service = service;
        this.accountRules = accountRules;
        this.laboratoryRules = laboratoryRules;
        this.practiceService = practiceService;
    }

    public void endPeriod(Party customer, Date date, boolean postCompletedCharges) {
        EndOfPeriodProcessor processor = this.createEndOfPeriodProcessor(date, postCompletedCharges);
        try {
            this.endPeriodExecutor.run((Object)customer.getId(), () -> processor.process(customer));
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new StatementProcessorException(StatementProcessorException.ErrorCode.FailedToProcessStatement, exception.getMessage());
        }
    }

    private EndOfPeriodProcessor createEndOfPeriodProcessor(Date date, boolean postCompletedCharges) {
        Party practice = this.practiceService.getPractice();
        if (practice == null) {
            throw new IllegalStateException("No practice");
        }
        return new EndOfPeriodProcessor(date, postCompletedCharges, practice, this.service, this.accountRules, this.laboratoryRules);
    }
}

