/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.estimate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openvpms.archetype.rules.act.ActCopyHandler;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class EstimateRules {
    private final IArchetypeService service;
    private static final String CLINICIAN = "clinician";

    public EstimateRules(IArchetypeService service) {
        this.service = service;
    }

    public Act copy(Act estimate) {
        return this.copy(estimate, estimate.getTitle());
    }

    public Act copy(Act estimate, String title) {
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)this.createEstimateCopyHandler(), (ArchetypeService)this.service);
        List objects = copier.apply((IMObject)estimate);
        Act copy = (Act)objects.get(0);
        copy.setTitle(title);
        this.service.save((Collection)objects);
        return (Act)objects.get(0);
    }

    public FinancialAct invoice(Act estimate, User clinician) {
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new EstimateHandler(), (ArchetypeService)this.service);
        List objects = copier.apply((IMObject)estimate);
        ArrayList<Act> items = new ArrayList<Act>();
        for (IMObject object : objects) {
            if (!object.isA("act.customerAccountInvoiceItem")) continue;
            Act item = (Act)object;
            if (clinician != null) {
                IMObjectBean bean = this.service.getBean((IMObject)item);
                bean.setTarget(CLINICIAN, (IMObject)clinician);
            }
            items.add((Act)object);
        }
        FinancialAct invoice = (FinancialAct)objects.get(0);
        if (clinician != null) {
            IMObjectBean bean = this.service.getBean((IMObject)invoice);
            bean.setTarget(CLINICIAN, (IMObject)clinician);
        }
        this.service.getBean((IMObject)estimate).addTarget("invoice", (IMObject)invoice, "estimates");
        List<IMObject> dispensing = this.addDispensingActs(items);
        objects.addAll(dispensing);
        estimate.setStatus("INVOICED");
        objects.add(estimate);
        this.service.save((Collection)objects);
        return invoice;
    }

    public boolean isPatientEstimate(Act estimate, Party patient) {
        IMObjectBean bean = this.service.getBean((IMObject)estimate);
        Reference ref = patient.getObjectReference();
        for (Act item : bean.getTargets("items", Act.class)) {
            IMObjectBean itemBean = this.service.getBean((IMObject)item);
            if (Objects.equals(ref, itemBean.getTargetRef("patient"))) continue;
            return false;
        }
        return true;
    }

    protected ActCopyHandler createEstimateCopyHandler() {
        return new ActCopyHandler(){

            @Override
            protected boolean checkCopyable(ArchetypeDescriptor archetype, NodeDescriptor node) {
                boolean result = super.checkCopyable(archetype, node);
                if (result && "invoice".equals(node.getName())) {
                    result = false;
                }
                return result;
            }
        };
    }

    private List<IMObject> addDispensingActs(List<Act> items) {
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        for (Act item : items) {
            IMObjectBean bean = this.service.getBean((IMObject)item);
            Reference product = bean.getTargetRef("product");
            if (!TypeHelper.isA((Reference)product, (String)"product.medication")) continue;
            IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new DispensingHandler(), (ArchetypeService)this.service);
            List objects = copier.apply((IMObject)item);
            Act medication = (Act)objects.get(0);
            ActRelationship relationship = (ActRelationship)bean.addTarget("dispensing", (IMObject)medication);
            medication.addActRelationship(relationship);
            result.addAll(objects);
        }
        return result;
    }

    private static class DispensingHandler
    extends ActCopyHandler {
        private static final String[][] typeMap = new String[][]{{"act.customerAccountInvoiceItem", "act.patientMedication"}};

        DispensingHandler() {
            super(typeMap);
        }

        @Override
        protected boolean isCopyable(ArchetypeDescriptor archetype, NodeDescriptor node, boolean source) {
            boolean result = super.isCopyable(archetype, node, source);
            if (result && TypeHelper.isA((org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, (String)"act.customerAccountInvoiceItem")) {
                String name = node.getName();
                result = "quantity".equals(name) || "patient".equals(name) || "product".equals(name) || EstimateRules.CLINICIAN.equals(name);
            }
            return result;
        }
    }

    private static class EstimateHandler
    extends ActCopyHandler {
        private static final String[][] TYPE_MAP = new String[][]{{"act.customerEstimation", "act.customerAccountChargesInvoice"}, {"act.customerEstimationItem", "act.customerAccountInvoiceItem"}, {"actRelationship.customerEstimationItem", "actRelationship.customerAccountInvoiceItem"}};

        public EstimateHandler() {
            super(TYPE_MAP);
        }

        protected NodeDescriptor getTargetNode(ArchetypeDescriptor source, NodeDescriptor sourceNode, ArchetypeDescriptor target) {
            String name = sourceNode.getName();
            if (TypeHelper.isA((org.openvpms.component.model.archetype.ArchetypeDescriptor)target, (String)"act.customerAccountInvoiceItem")) {
                if (name.equals("highQty")) {
                    return target.getNodeDescriptor("quantity");
                }
                if (name.equals("highUnitPrice")) {
                    return target.getNodeDescriptor("unitPrice");
                }
                if (name.equals("highDiscount")) {
                    return target.getNodeDescriptor("discount");
                }
                if (name.equals("highTotal")) {
                    return target.getNodeDescriptor("total");
                }
            } else if (TypeHelper.isA((org.openvpms.component.model.archetype.ArchetypeDescriptor)target, (String)"act.customerAccountChargesInvoice") && name.equals("highTotal")) {
                return target.getNodeDescriptor("amount");
            }
            return super.getTargetNode(source, sourceNode, target);
        }
    }
}

