/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.discount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.CollectionNodeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.openvpms.component.system.common.query.ShortNameConstraint;

public class DiscountRules {
    public static final String PERCENTAGE = "PERCENTAGE";
    public static final String FIXED = "FIXED";
    public static final String COST_RATE = "COST_RATE";
    private final IArchetypeService service;
    private static final String DISCOUNTS = "discounts";

    public DiscountRules(IArchetypeService service) {
        this.service = service;
    }

    public BigDecimal calculateDiscount(Date date, Party practice, Party customer, Party patient, Product product, BigDecimal fixedCost, BigDecimal unitCost, BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal quantity, BigDecimal maxFixedPriceDiscount, BigDecimal maxUnitPriceDiscount) {
        BigDecimal discount;
        quantity = quantity.abs();
        BigDecimal taxRate = BigDecimal.ZERO;
        if (practice != null) {
            CustomerTaxRules taxRules = new CustomerTaxRules(practice, this.service);
            taxRate = taxRules.getTaxRate(product, customer);
        }
        if (fixedPrice.compareTo(BigDecimal.ZERO) == 0 && (unitPrice.compareTo(BigDecimal.ZERO) == 0 || quantity.compareTo(BigDecimal.ZERO) == 0)) {
            discount = BigDecimal.ZERO;
        } else {
            List<Entity> discounts = this.getDiscounts(date, customer, patient, product);
            if (discounts.isEmpty()) {
                discount = BigDecimal.ZERO;
            } else {
                BigDecimal maxDiscount;
                discount = this.calculateDiscountAmount(fixedPrice, unitPrice, fixedCost, unitCost, quantity, taxRate, discounts);
                if (discount.compareTo(maxDiscount = this.calculateMaxDiscount(fixedPrice, unitPrice, quantity, maxFixedPriceDiscount, maxUnitPriceDiscount)) > 0) {
                    discount = maxDiscount;
                }
            }
        }
        return MathRules.round(discount);
    }

    public List<Entity> getDiscounts(Date date, Party customer, Party patient, Product product) {
        List<Entity> result = Collections.emptyList();
        DiscountGroups groups = new DiscountGroups(date);
        Set<Reference> productSet = this.getProductDiscounts(product, date, groups);
        if (!productSet.isEmpty()) {
            Set<Reference> customerSet = this.getPartyDiscounts(customer, date, groups);
            Set<Reference> patientSet = this.getPartyDiscounts(patient, date, groups);
            HashSet<Reference> partySet = new HashSet<Reference>(customerSet);
            partySet.addAll(patientSet);
            HashSet<Reference> refs = new HashSet<Reference>(productSet);
            refs.retainAll(partySet);
            if (!refs.isEmpty()) {
                result = new ArrayList<Entity>();
                for (Reference ref : refs) {
                    Entity discount = (Entity)this.service.get(ref);
                    if (discount == null || !discount.isActive()) continue;
                    result.add(discount);
                }
            }
        }
        return result;
    }

    private BigDecimal calculateDiscountAmount(BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal fixedCost, BigDecimal unitCost, BigDecimal quantity, BigDecimal taxRate, List<Entity> discounts) {
        BigDecimal result = BigDecimal.ZERO;
        Entity lastCostDiscount = null;
        BigDecimal lastCostRate = null;
        boolean lastCostDiscountFixed = false;
        for (Entity discount : discounts.toArray(new Entity[0])) {
            IMObjectBean discountBean = this.service.getBean((IMObject)discount);
            String discountType = discountBean.getString("type");
            if (!COST_RATE.equals(discountType)) continue;
            BigDecimal rate = discountBean.getBigDecimal("rate", BigDecimal.ZERO);
            boolean discountFixed = discountBean.getBoolean("discountFixed");
            if (lastCostDiscount == null || this.lessThan(rate, lastCostRate, discountFixed, lastCostDiscountFixed)) {
                if (lastCostDiscount != null) {
                    discounts.remove(lastCostDiscount);
                }
                lastCostDiscount = discount;
                lastCostRate = rate;
                lastCostDiscountFixed = discountFixed;
                continue;
            }
            discounts.remove(discount);
        }
        for (Entity discount : discounts) {
            BigDecimal amount = this.calculateDiscountAmount(fixedPrice, unitPrice, fixedCost, unitCost, quantity, taxRate, discount);
            result = result.add(amount);
        }
        return result;
    }

    private BigDecimal calculateDiscountAmount(BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal fixedCost, BigDecimal unitCost, BigDecimal quantity, BigDecimal taxRate, Entity discount) {
        BigDecimal dFixedPrice;
        boolean discountFixed;
        IMObjectBean discountBean = this.service.getBean((IMObject)discount);
        String discountType = discountBean.getString("type");
        BigDecimal rate = discountBean.getBigDecimal("rate", BigDecimal.ZERO);
        boolean bl = discountFixed = !FIXED.equals(discountType) && discountBean.getBoolean("discountFixed");
        if (discountFixed) {
            BigDecimal fixedQty = new BigDecimal(quantity.compareTo(BigDecimal.ZERO)).abs();
            dFixedPrice = fixedQty.multiply(this.calcDiscount(fixedCost, fixedPrice, rate, taxRate, discountType));
        } else {
            dFixedPrice = BigDecimal.ZERO;
        }
        BigDecimal dUnitPrice = this.calcDiscount(unitCost, unitPrice, rate, taxRate, discountType);
        BigDecimal amount = PERCENTAGE.equals(discountType) || COST_RATE.equals(discountType) ? (quantity.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : quantity.abs().multiply(dUnitPrice).add(dFixedPrice)) : dUnitPrice.add(dFixedPrice);
        return amount;
    }

    private boolean lessThan(BigDecimal costRate1, BigDecimal costRate2, boolean discountFixed1, boolean discountFixed2) {
        int comp = costRate1.compareTo(costRate2);
        return comp < 0 || comp == 0 && !discountFixed1 && discountFixed2;
    }

    private BigDecimal calculateMaxDiscount(BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal quantity, BigDecimal fixedDiscountRate, BigDecimal unitDiscountRate) {
        BigDecimal dFixedPrice = this.calcDiscount(fixedPrice, fixedDiscountRate);
        BigDecimal dUnitPrice = this.calcDiscount(unitPrice, unitDiscountRate);
        return quantity.multiply(dUnitPrice).add(dFixedPrice);
    }

    private BigDecimal calcDiscount(BigDecimal costPrice, BigDecimal price, BigDecimal rate, BigDecimal taxRate, String discountType) {
        BigDecimal result;
        if (PERCENTAGE.equals(discountType)) {
            result = this.calcDiscount(price, rate);
        } else if (COST_RATE.equals(discountType)) {
            BigDecimal discountedCostPrice = costPrice.add(this.calcDiscount(costPrice, rate));
            result = price.subtract(discountedCostPrice.add(this.calcDiscount(discountedCostPrice, taxRate)));
        } else {
            result = rate;
        }
        return result;
    }

    private BigDecimal calcDiscount(BigDecimal amount, BigDecimal rate) {
        BigDecimal result = amount.multiply(rate);
        result = MathRules.divide(result, MathRules.ONE_HUNDRED, 3);
        return result;
    }

    private Set<Reference> getPartyDiscounts(Party party, Date date, DiscountGroups discountGroups) {
        IMObjectBean bean;
        List result = Collections.emptyList();
        if (party != null && (bean = this.service.getBean((IMObject)party)).hasNode(DISCOUNTS)) {
            result = bean.getTargetRefs(DISCOUNTS, Policies.active((Date)date));
        }
        return this.expandGroups(result, discountGroups);
    }

    private Set<Reference> getProductDiscounts(Product product, Date date, DiscountGroups discountGroups) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        HashSet<Reference> discounts = new HashSet<Reference>();
        if (bean.hasNode(DISCOUNTS)) {
            Reference type;
            discounts.addAll(bean.getTargetRefs(DISCOUNTS, Policies.active((Date)date)));
            if (bean.hasNode("type") && (type = bean.getTargetRef("type")) != null) {
                discounts.addAll(this.getProductTypeDiscounts(type, date, discountGroups));
            }
        }
        return this.expandGroups(discounts, discountGroups);
    }

    private Set<Reference> getProductTypeDiscounts(Reference ref, Date date, DiscountGroups discountGroups) {
        List<Reference> discounts = this.getRelatedEntityReferences(ref, "entityLink.productTypeDiscount", DISCOUNTS, date);
        return this.expandGroups(discounts, discountGroups);
    }

    private Set<Reference> expandGroups(Collection<Reference> discounts, DiscountGroups groups) {
        if (discounts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Reference> result = new HashSet<Reference>();
        for (Reference ref : discounts) {
            if (ref.isA("entity.discountGroupType")) {
                result.addAll(groups.getDiscountTypes(ref));
                continue;
            }
            result.add(ref);
        }
        return result;
    }

    private List<Reference> getRelatedEntityReferences(Reference ref, String relationshipShortName, String collectionNodeName, Date date) {
        List<Reference> result;
        ShortNameConstraint rel = new ShortNameConstraint("rel", relationshipShortName, true, false);
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)new ObjectRefConstraint(ref));
        query.getArchetypeConstraint().setAlias("e");
        query.add((IConstraint)Constraints.eq((String)"e.active", (Object)true));
        query.add((IConstraint)new CollectionNodeConstraint(collectionNodeName, (BaseArchetypeConstraint)rel));
        query.add((IConstraint)new ObjectRefSelectConstraint("rel.target"));
        OrConstraint startTime = new OrConstraint();
        startTime.add((IConstraint)new NodeConstraint("activeStartTime", RelationalOp.IS_NULL));
        startTime.add((IConstraint)new NodeConstraint("activeStartTime", RelationalOp.LTE, new Object[]{date}));
        OrConstraint endTime = new OrConstraint();
        endTime.add((IConstraint)new NodeConstraint("activeEndTime", RelationalOp.IS_NULL));
        endTime.add((IConstraint)new NodeConstraint("activeEndTime", RelationalOp.GTE, new Object[]{date}));
        rel.add((IConstraint)startTime);
        rel.add((IConstraint)endTime);
        query.setMaxResults(-1);
        ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        if (iter.hasNext()) {
            result = new ArrayList();
            while (iter.hasNext()) {
                ObjectSet set = (ObjectSet)iter.next();
                result.add((Reference)set.getReference("rel.target.reference"));
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private class DiscountGroups {
        private final Date date;
        private final Map<Reference, List<Reference>> groups = new HashMap<Reference, List<Reference>>();

        public DiscountGroups(Date date) {
            this.date = date;
        }

        public List<Reference> getDiscountTypes(Reference ref) {
            List result = this.groups.get(ref);
            if (result == null) {
                result = DiscountRules.this.getRelatedEntityReferences(ref, "entityLink.discountType", DiscountRules.DISCOUNTS, this.date);
                this.groups.put(ref, result);
            }
            return result;
        }
    }
}

