/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.credit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.finance.credit.AllocationBlock;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class CreditAllocation {
    private final FinancialAct credit;
    private final Map<FinancialAct, AllocationBlock> blocked;
    private final List<FinancialAct> modified;
    private final List<FinancialAct> debits;
    private final ArchetypeService service;
    private String displayName;

    public CreditAllocation(FinancialAct credit, ArchetypeService service) {
        this(credit, Collections.emptyList(), service);
    }

    public CreditAllocation(FinancialAct credit, List<FinancialAct> debits, ArchetypeService service) {
        this(credit, debits, Collections.emptyMap(), service);
    }

    public CreditAllocation(FinancialAct credit, List<FinancialAct> debits, Map<FinancialAct, AllocationBlock> blocked, ArchetypeService service) {
        this(credit, debits, blocked, Collections.emptyList(), service);
    }

    public CreditAllocation(FinancialAct credit, List<FinancialAct> debits, Map<FinancialAct, AllocationBlock> blocked, List<FinancialAct> modified, ArchetypeService service) {
        this.credit = credit;
        this.debits = debits;
        this.blocked = blocked;
        this.modified = modified;
        this.service = service;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = DescriptorHelper.getDisplayName((IMObject)this.credit, (ArchetypeService)this.service);
        }
        return this.displayName;
    }

    public FinancialAct getCredit() {
        return this.credit;
    }

    public List<FinancialAct> getDebits() {
        return this.debits;
    }

    public Map<FinancialAct, AllocationBlock> getBlocked() {
        return this.blocked;
    }

    public List<FinancialAct> getModified() {
        return this.modified;
    }

    public boolean overrideDefaultAllocation() {
        return this.modified.isEmpty() && !this.blocked.isEmpty();
    }

    public boolean isModified() {
        return !this.modified.isEmpty();
    }
}

