/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.account.CustomerActReversalHandler;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

class ReversalRules {
    private final ArchetypeService service;
    private static final String HIDE = "hide";
    private static final String NOTES = "notes";
    private static final String REFERENCE = "reference";
    private static final String REVERSAL = "reversal";
    private static final String REVERSES = "reverses";

    public ReversalRules(ArchetypeService service) {
        this.service = service;
    }

    public boolean isReversed(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.hasNode(REVERSAL) && !bean.getValues(REVERSAL).isEmpty();
    }

    public boolean isReversal(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return bean.hasNode(REVERSES) && !bean.getValues(REVERSES).isEmpty();
    }

    public Reversal reverse(FinancialAct act, Date startTime, String reference, String notes, boolean post, boolean hide) {
        if (!"POSTED".equals(act.getStatus())) {
            throw new IllegalStateException("Cannot reverse act with status " + act.getStatus());
        }
        IMObjectBean original = this.service.getBean((IMObject)act);
        if (!original.getValues(REVERSAL).isEmpty()) {
            throw new IllegalStateException("Act=" + act.getId() + " has already been reversed");
        }
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new CustomerActReversalHandler((Act)act, post), this.service);
        List copies = copier.apply((IMObject)act);
        FinancialAct reversal = (FinancialAct)copies.get(0);
        IMObjectBean bean = this.service.getBean((IMObject)reversal);
        bean.setValue(REFERENCE, !StringUtils.isEmpty((CharSequence)reference) ? reference : Long.valueOf(act.getId()));
        bean.setValue(NOTES, (Object)notes);
        if (post) {
            reversal.setStatus("POSTED");
        } else {
            reversal.setStatus("IN_PROGRESS");
        }
        reversal.setActivityStartTime(startTime);
        original.addTarget(REVERSAL, (IMObject)reversal, REVERSES);
        if (hide && !original.getBoolean(HIDE)) {
            bean.setValue(HIDE, (Object)true);
            original.setValue(HIDE, (Object)true);
        }
        return new Reversal(reversal, new HashSet<IMObject>(copies));
    }

    public static class Reversal {
        private final FinancialAct reversal;
        private final Set<IMObject> changes;

        public Reversal(FinancialAct reversal, Set<IMObject> changes) {
            this.reversal = reversal;
            this.changes = changes;
        }

        public FinancialAct getReversal() {
            return this.reversal;
        }

        public Set<IMObject> getChanges() {
            return this.changes;
        }
    }
}

