/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.util.Iterator;
import java.util.List;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.CollectionNodeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.IdConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSelectConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;

public class OutstandingBalanceQuery {
    private final IArchetypeService service;
    private Lookup accountType;
    private boolean debit = false;

    public OutstandingBalanceQuery(IArchetypeService service) {
        this.service = service;
    }

    public void setAccountType(Lookup accountType) {
        this.accountType = accountType;
    }

    public void setDebitOnly(boolean debit) {
        this.debit = debit;
    }

    public Iterator<Party> query() {
        List<String> archetypes = this.debit ? CustomerAccountArchetypes.DEBITS : CustomerAccountArchetypes.DEBITS_CREDITS;
        ShortNameConstraint acts = new ShortNameConstraint("act", archetypes, true, true);
        ShortNameConstraint balance = new ShortNameConstraint("balance", "participation.customerAccountBalance", true, true);
        String alias = "customer";
        ShortNameConstraint customer = new ShortNameConstraint("customer", "party.customer*", true, true);
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)acts);
        query.add((IConstraint)new NodeConstraint("status", (Object)"POSTED"));
        query.add((IConstraint)new ObjectSelectConstraint("customer"));
        query.add((IConstraint)new CollectionNodeConstraint("accountBalance", (BaseArchetypeConstraint)balance));
        query.add((IConstraint)customer);
        query.add((IConstraint)new IdConstraint("balance.entity", "customer"));
        query.add((IConstraint)new IdConstraint("balance.act", "act"));
        if (this.accountType != null) {
            ShortNameConstraint type = new ShortNameConstraint("type", "lookup.customerAccountType", true, true);
            ObjectRefConstraint objRef = new ObjectRefConstraint("lookup", this.accountType.getObjectReference());
            customer.add((IConstraint)new CollectionNodeConstraint("type", (BaseArchetypeConstraint)type));
            query.add((IConstraint)objRef);
            query.add((IConstraint)new IdConstraint("type", "lookup"));
        }
        query.add((IConstraint)new NodeSortConstraint("customer", "name"));
        query.setDistinct(true);
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }
}

