/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class EmailTemplate
extends BaseDocumentTemplate {
    private static final String PDF_TYPE = "application/pdf";

    public EmailTemplate(Entity template, ArchetypeService service) {
        super(template, service);
    }

    public SubjectType getSubjectType() {
        return SubjectType.valueOf(this.getBean().getString("subjectType", SubjectType.TEXT.name()));
    }

    public String getSubject() {
        return this.getBean().getString("subject");
    }

    public String getSubjectSource() {
        return this.getBean().getString("subjectSource");
    }

    public ContentType getContentType() {
        return ContentType.valueOf(this.getBean().getString("contentType", ContentType.TEXT.name()));
    }

    public String getContent() {
        return this.getBean().getString("content");
    }

    public String getContentSource() {
        return this.getBean().getString("contentSource");
    }

    public String getDefaultEmailAddress() {
        return this.getBean().getString("defaultEmailAddress");
    }

    public List<DocumentTemplate> getAttachments() {
        return this.getAttachments(false);
    }

    public List<DocumentTemplate> getAttachments(boolean sortOnName) {
        Comparator<Entity> comparator = sortOnName ? Comparator.comparing(IMObject::getName) : Comparator.comparing(IMObject::getId);
        return this.getBean().getTargets("attachments", Entity.class, Policies.active()).stream().sorted(comparator).map(template -> new DocumentTemplate((Entity)template, this.getService())).filter(template -> PDF_TYPE.equals(template.getMimeType())).collect(Collectors.toList());
    }

    public static enum ContentType {
        TEXT,
        MACRO,
        XPATH,
        DOCUMENT;

    }

    public static enum SubjectType {
        TEXT,
        MACRO,
        XPATH;

    }
}

