/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.Sides;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class DocumentTemplatePrinter {
    private final IMObjectBean bean;

    public DocumentTemplatePrinter(EntityRelationship relationship, ArchetypeService service) {
        this.bean = service.getBean((IMObject)relationship);
    }

    public PrinterReference getPrinter() {
        return PrinterReference.fromString(this.bean.getString("printer"));
    }

    public void setPrinter(String name) {
        this.bean.setValue("printer", (Object)name);
    }

    public String getPaperTray() {
        return this.bean.getString("paperTray");
    }

    public void setPaperTray(String tray) {
        this.bean.setValue("paperTray", (Object)tray);
    }

    public boolean getInteractive() {
        return this.bean.getBoolean("interactive");
    }

    public String getPrintSides() {
        return this.bean.getString("sides");
    }

    public void setPrintSides(String sides) {
        this.bean.setValue("sides", (Object)sides);
    }

    public void setInteractive(boolean interactive) {
        this.bean.setValue("interactive", (Object)interactive);
    }

    public MediaTray getMediaTray() {
        String tray = this.getPaperTray();
        return tray != null ? Tray.getTray(tray) : null;
    }

    public Sides getSides() {
        String sides = this.getPrintSides();
        return sides != null ? PrintSides.getSides(sides) : null;
    }

    public Entity getTemplate() {
        return (Entity)this.bean.getObject("source");
    }

    public Reference getTemplateRef() {
        return this.bean.getReference("source");
    }

    public Entity getLocation() {
        return (Entity)this.bean.getObject("target");
    }

    public Reference getLocationRef() {
        return this.bean.getReference("target");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DocumentTemplatePrinter) {
            DocumentTemplatePrinter p = (DocumentTemplatePrinter)other;
            return p.bean.getObject().equals(this.bean.getObject());
        }
        return false;
    }

    public int hashCode() {
        return this.getRelationship().hashCode();
    }

    public EntityRelationship getRelationship() {
        return (EntityRelationship)this.bean.getObject(EntityRelationship.class);
    }

    private static enum PrintSides {
        ONE_SIDED(Sides.ONE_SIDED),
        TWO_SIDED_LONG_EDGE(Sides.TWO_SIDED_LONG_EDGE),
        TWO_SIDED_SHORT_EDGE(Sides.TWO_SIDED_SHORT_EDGE);

        private final Sides sides;

        private PrintSides(Sides sides) {
            this.sides = sides;
        }

        public Sides getSides() {
            return this.sides;
        }

        public static Sides getSides(String sides) {
            for (PrintSides s : PrintSides.values()) {
                if (!s.name().equals(sides)) continue;
                return s.getSides();
            }
            throw new DocumentException(DocumentException.ErrorCode.InvalidSides, sides);
        }
    }

    private static enum Tray {
        TOP(MediaTray.TOP),
        MIDDLE(MediaTray.MIDDLE),
        BOTTOM(MediaTray.BOTTOM),
        ENVELOPE(MediaTray.ENVELOPE),
        MANUAL(MediaTray.MANUAL),
        LARGE_CAPACITY(MediaTray.LARGE_CAPACITY),
        MAIN(MediaTray.MAIN),
        SIDE(MediaTray.SIDE);

        private final MediaTray mediaTray;

        private Tray(MediaTray mediaTray) {
            this.mediaTray = mediaTray;
        }

        public MediaTray getTray() {
            return this.mediaTray;
        }

        public static MediaTray getTray(String name) {
            for (Tray tray : Tray.values()) {
                if (!tray.name().equals(name)) continue;
                return tray.getTray();
            }
            throw new DocumentException(DocumentException.ErrorCode.InvalidMediaTray, name);
        }
    }
}

