/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentTemplatePrinter;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class DocumentTemplate
extends BaseDocumentTemplate {
    public static final String A4 = "A4";
    public static final String A5 = "A5";
    public static final String LETTER = "LETTER";
    public static final String CUSTOM = "CUSTOM";
    public static final String PORTRAIT = "PORTRAIT";
    public static final String LANDSCAPE = "LANDSCAPE";
    public static final String MM = "MM";
    public static final String INCH = "INCH";
    public static final String REPORT = "REPORT";
    public static final String SUBREPORT = "SUBREPORT";
    private EmailTemplate email;
    private Entity sms;
    private static final String PRINTERS = "printers";

    public DocumentTemplate(Entity template, ArchetypeService service) {
        super(template, service);
    }

    public String getType() {
        Lookup type = (Lookup)this.getBean().getObject("type", Lookup.class);
        return type != null ? type.getCode() : null;
    }

    public String getUserLevel() {
        return this.getBean().getString("userLevel");
    }

    public String getReportType() {
        return this.getBean().getString("reportType");
    }

    public PrintMode getPrintMode() {
        String mode = this.getBean().getString("printMode");
        return mode != null ? PrintMode.valueOf(mode) : null;
    }

    public String getPaperSize() {
        return this.getBean().getString("paperSize");
    }

    public String getOrientation() {
        return this.getBean().getString("orientation");
    }

    public int getCopies() {
        return this.getBean().getInt("copies");
    }

    public Format getOutputFormat() {
        String format = this.getBean().getString("outputFormat");
        return format != null ? Format.valueOf(format) : null;
    }

    public BigDecimal getPaperHeight() {
        return this.getBean().getBigDecimal("paperHeight");
    }

    public BigDecimal getPaperWidth() {
        return this.getBean().getBigDecimal("paperWidth");
    }

    public String getPaperUnits() {
        return this.getBean().getString("paperUnits");
    }

    public EmailTemplate getEmailTemplate() {
        Entity entity;
        if (this.email == null && (entity = (Entity)this.getBean().getTarget("email", Entity.class, Policies.active())) != null) {
            this.email = new EmailTemplate(entity, this.getService());
        }
        return this.email;
    }

    public Entity getSMSTemplate() {
        if (this.sms == null) {
            this.sms = (Entity)this.getBean().getTarget("sms", Entity.class, Policies.active());
        }
        return this.sms;
    }

    public MediaSizeName getMediaSize() {
        String size = this.getPaperSize();
        if (size != null) {
            BigDecimal width = this.getPaperWidth();
            BigDecimal height = this.getPaperHeight();
            String units = this.getPaperUnits();
            MediaSizeName media = PaperSize.CUSTOM.name().equals(size) ? this.getMedia(width, height, units) : PaperSize.getMediaSizeName(size);
            return media;
        }
        return null;
    }

    public OrientationRequested getOrientationRequested() {
        return this.getOrientation() != null ? Orientation.getOrientation(this.getOrientation()) : null;
    }

    public List<DocumentTemplatePrinter> getPrinters() {
        ArrayList<DocumentTemplatePrinter> result = new ArrayList<DocumentTemplatePrinter>();
        List printers = this.getBean().getValues(PRINTERS, EntityRelationship.class);
        for (EntityRelationship printer : printers) {
            result.add(new DocumentTemplatePrinter(printer, this.getService()));
        }
        return result;
    }

    public DocumentTemplatePrinter getPrinter(Entity location) {
        Predicate predicate = Predicates.activeNow().and(Predicates.targetEquals((IMObject)location));
        EntityRelationship printer = (EntityRelationship)this.getBean().getValue(PRINTERS, EntityRelationship.class, predicate);
        return printer != null ? new DocumentTemplatePrinter(printer, this.getService()) : null;
    }

    public String getFileNameExpression() {
        List fileNameFormat = this.getBean().getValues("fileNameFormat");
        if (!fileNameFormat.isEmpty()) {
            IMObjectBean format = this.getService().getBean((IMObject)fileNameFormat.get(0));
            return format.getString("expression");
        }
        return null;
    }

    public boolean isLetter() {
        return DocumentTemplate.isLetter(this.getType());
    }

    public static boolean isForm(String type) {
        return "act.patientDocumentForm".equals(type) || "act.customerDocumentForm".equals(type) || "act.supplierDocumentForm".equals(type);
    }

    public static boolean isLetter(String type) {
        return "act.patientDocumentLetter".equals(type) || "act.customerDocumentLetter".equals(type) || "act.supplierDocumentLetter".equals(type);
    }

    public static boolean isReport(String type) {
        return REPORT.equals(type) || SUBREPORT.equals(type);
    }

    private MediaSizeName getMedia(BigDecimal width, BigDecimal height, String units) {
        int unitCode = Units.getUnits(units);
        try {
            return MediaSize.findMedia(width.floatValue(), height.floatValue(), unitCode);
        }
        catch (IllegalArgumentException exception) {
            String size = width + "x" + height + " " + units;
            throw new DocumentException(DocumentException.ErrorCode.InvalidPaperSize, size);
        }
    }

    private static enum Units {
        MM(1000),
        INCH(25400);

        private final int value;

        private Units(int value) {
            this.value = value;
        }

        public int getUnits() {
            return this.value;
        }

        public static int getUnits(String units) {
            for (Units u : Units.values()) {
                if (!u.name().equals(units)) continue;
                return u.getUnits();
            }
            throw new DocumentException(DocumentException.ErrorCode.InvalidUnits, units);
        }
    }

    private static enum PaperSize {
        A4(MediaSizeName.ISO_A4),
        A5(MediaSizeName.ISO_A5),
        LETTER(MediaSizeName.NA_LETTER),
        CUSTOM(null);

        private final MediaSizeName mediaName;

        private PaperSize(MediaSizeName name) {
            this.mediaName = name;
        }

        public MediaSizeName getMediaSizeName() {
            return this.mediaName;
        }

        public static MediaSizeName getMediaSizeName(String name) {
            for (PaperSize size : PaperSize.values()) {
                if (!size.name().equals(name)) continue;
                return size.getMediaSizeName();
            }
            throw new DocumentException(DocumentException.ErrorCode.InvalidPaperSize, name);
        }
    }

    private static enum Orientation {
        PORTRAIT(OrientationRequested.PORTRAIT),
        LANDSCAPE(OrientationRequested.LANDSCAPE);

        private final OrientationRequested orientationRequested;

        private Orientation(OrientationRequested orientationRequested) {
            this.orientationRequested = orientationRequested;
        }

        public OrientationRequested getOrientation() {
            return this.orientationRequested;
        }

        public static OrientationRequested getOrientation(String orientation) {
            for (Orientation o : Orientation.values()) {
                if (!o.name().equals(orientation)) continue;
                return o.getOrientation();
            }
            throw new DocumentException(DocumentException.ErrorCode.InvalidOrientation, orientation);
        }
    }

    public static enum Format {
        PDF("application/pdf"),
        ODT("application/vnd.oasis.opendocument.text");

        private final String mimeType;

        private Format(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    public static enum PrintMode {
        IMMEDIATE,
        MANUAL,
        CHECK_OUT;

    }
}

