/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openvpms.archetype.rules.doc.DefaultDocumentHandler;
import org.openvpms.archetype.rules.doc.DelegatingDocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.SupportedImageDocumentHandler;
import org.openvpms.archetype.rules.doc.TemporaryDocumentHandler;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;

public class DocumentHandlers {
    private final DelegatingDocumentHandler handlers;

    public DocumentHandlers(ArchetypeService service) {
        this(service, Collections.emptyList());
    }

    public DocumentHandlers(ArchetypeService service, List<DocumentHandler> handlers) {
        ArrayList<DocumentHandler> list = new ArrayList<DocumentHandler>(handlers);
        list.add(new SupportedImageDocumentHandler(service));
        list.add(new TemporaryDocumentHandler(service));
        list.add(new DefaultDocumentHandler(service));
        this.handlers = new DelegatingDocumentHandler(list);
    }

    public DocumentHandler find(Document document) {
        return this.find(document.getName(), document.getArchetype(), document.getMimeType());
    }

    public DocumentHandler get(Document document) {
        return this.get(document.getName(), document.getArchetype(), document.getMimeType());
    }

    public DocumentHandler find(String name, String mimeType) {
        return this.handlers.find(name, mimeType);
    }

    public DocumentHandler get(String name, String mimeType) {
        DocumentHandler handler = this.find(name, mimeType);
        if (handler == null) {
            throw new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, name, mimeType);
        }
        return handler;
    }

    public DocumentHandler find(String name, String archetype, String mimeType) {
        return this.handlers.find(name, archetype, mimeType);
    }

    public DocumentHandler get(String name, String shortName, String mimeType) {
        DocumentHandler handler = this.find(name, shortName, mimeType);
        if (handler == null) {
            throw new DocumentException(DocumentException.ErrorCode.UnsupportedDoc, name, mimeType);
        }
        return handler;
    }
}

