/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractImageService
implements ImageService {
    private final DocumentHandlers handlers;
    private final ArchetypeService service;

    public AbstractImageService(DocumentHandlers handlers, ArchetypeService service) {
        this.handlers = handlers;
        this.service = service;
    }

    @Override
    public URL getURL(DocumentAct act) {
        URL result;
        ImageService.Image image = this.getImage(act);
        try {
            result = image != null ? image.getURL() : null;
        }
        catch (Exception exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, exception, act.getFileName());
        }
        return result;
    }

    @Override
    public ImageService.Image getImage(DocumentAct act) {
        ImageImpl result;
        String fileName = act.getId() + "_" + act.getVersion() + "_" + this.sanitizeFilename(act);
        File dir = this.getDir();
        File file = new File(dir, fileName);
        try {
            Document document;
            if (!file.exists() && (document = (Document)this.service.get(act.getDocument(), Document.class)) != null) {
                DocumentHandler handler = this.handlers.get((org.openvpms.component.model.document.Document)document);
                File tmp = File.createTempFile("img", null, dir);
                FileCopyUtils.copy((InputStream)handler.getContent((org.openvpms.component.model.document.Document)document), (OutputStream)new FileOutputStream(tmp));
                if (!tmp.renameTo(file)) {
                    throw new DocumentException(DocumentException.ErrorCode.RenameError, tmp.getAbsolutePath(), file.getAbsolutePath());
                }
            }
            result = new ImageImpl(file, act.getMimeType());
        }
        catch (IOException exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, exception, act.getFileName());
        }
        return result;
    }

    protected abstract File getDir();

    private String sanitizeFilename(DocumentAct act) {
        String filename = act.getFileName();
        return filename != null ? filename.replaceAll("[^a-zA-Z0-9.]", "_") : "";
    }

    private static class ImageImpl
    implements ImageService.Image {
        private final File file;
        private final String mimeType;

        public ImageImpl(File file, String mimeType) {
            this.file = file;
            this.mimeType = mimeType;
        }

        @Override
        public URL getURL() throws IOException {
            return this.file.toURI().toURL();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.getURL().openStream();
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public long getSize() {
            long result = 0L;
            try {
                result = this.file.length();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public Date getModified() {
            Date result = null;
            try {
                long modified = this.file.lastModified();
                if (modified > 0L) {
                    result = new Date(modified);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return result;
        }
    }
}

