/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractDocumentHandler
implements DocumentHandler {
    private final String archetype;
    private final ArchetypeService service;
    private final boolean compress;

    protected AbstractDocumentHandler(String archetype, ArchetypeService service) {
        this(archetype, service, true);
    }

    protected AbstractDocumentHandler(String archetype, ArchetypeService service, boolean compress) {
        this.archetype = archetype;
        this.service = service;
        this.compress = compress;
    }

    @Override
    public boolean canHandle(String name, String mimeType) {
        return true;
    }

    @Override
    public boolean canHandle(String name, String archetype, String mimeType) {
        return this.archetype.equals(archetype) && this.canHandle(name, mimeType);
    }

    @Override
    public Document create(String name, InputStream stream, String mimeType, int size) {
        CRC32 checksum = new CRC32();
        MutableInt actualSize = new MutableInt(size);
        byte[] data = this.getContent(name, stream, actualSize, checksum);
        return this.create(name, data, mimeType, actualSize.intValue(), checksum.getValue());
    }

    @Override
    public void update(Document document, InputStream stream, String mimeType, int size) {
        CRC32 checksum = new CRC32();
        MutableInt actualSize = new MutableInt(size);
        byte[] content = this.getContent(document.getName(), stream, actualSize, checksum);
        if (mimeType == null) {
            mimeType = document.getMimeType();
        }
        this.update(document, document.getName(), content, mimeType, actualSize.intValue(), checksum.getValue());
    }

    @Override
    public boolean canHandle(org.openvpms.component.model.document.Document document) {
        return this.archetype.equals(document.getArchetype());
    }

    @Override
    public InputStream getContent(org.openvpms.component.model.document.Document document) {
        try {
            return this.getInputStream(document.getContent());
        }
        catch (IOException exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, exception, new Object[0]);
        }
    }

    @Override
    public Document create(String name, byte[] content, String mimeType, int size) {
        return this.create(name, content, mimeType, size, this.calculateChecksum(content));
    }

    public Document create(String name, byte[] content, String mimeType, int size, long checksum) {
        Document document = (Document)this.service.create(this.archetype, Document.class);
        return this.update(document, name, content, mimeType, size, checksum);
    }

    protected Document update(Document document, String name, byte[] content, String mimeType, int size, long checksum) {
        if (name != null) {
            name = FilenameUtils.getName((String)name);
        }
        document.setName(name);
        document.setMimeType(mimeType);
        document.setContents(content);
        document.setSize(size);
        document.setChecksum(checksum);
        return document;
    }

    protected OutputStream getOutputStream(OutputStream stream) {
        return this.compress ? new DeflaterOutputStream(stream) : stream;
    }

    protected InputStream getInputStream(InputStream stream) {
        return this.compress ? new InflaterInputStream(stream) : stream;
    }

    protected long calculateChecksum(byte[] content) {
        CRC32 checksum = new CRC32();
        checksum.update(content);
        return checksum.getValue();
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    private byte[] getContent(String name, InputStream stream, MutableInt size, CRC32 checksum) {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        OutputStream output = this.getOutputStream(bytes);
        int read = 0;
        int initialSize = size.intValue();
        try {
            int length;
            while ((length = stream.read(buffer)) != -1) {
                checksum.update(buffer, 0, length);
                output.write(buffer, 0, length);
                read += length;
            }
            if (initialSize != -1 && read != initialSize) {
                throw new DocumentException(DocumentException.ErrorCode.ReadError, name);
            }
            output.close();
        }
        catch (IOException exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, exception, name);
        }
        size.setValue(read);
        return bytes.toByteArray();
    }
}

