/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.act;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ActCalculator {
    private final ArchetypeService service;
    private final int scale;

    public ActCalculator(ArchetypeService service) {
        this(service, 2);
    }

    public ActCalculator(ArchetypeService service, int scale) {
        this.service = service;
        this.scale = scale;
    }

    public BigDecimal sum(Act act, String itemsNode, String node) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        List acts = bean.getTargets(itemsNode, Act.class);
        return this.sum(act, acts, node);
    }

    public <T extends Act> BigDecimal sum(Act act, Collection<T> acts, String node) {
        BigDecimal result = this.sum(acts, node);
        if (this.isCredit(act)) {
            result = result.negate();
        }
        return result;
    }

    public <T extends Act> BigDecimal sum(Iterator<T> acts, String node) {
        BigDecimal result = BigDecimal.ZERO;
        while (acts.hasNext()) {
            Act act = (Act)acts.next();
            BigDecimal amount = this.getAmount(act, node);
            result = result.add(amount);
        }
        return this.round(result);
    }

    public BigDecimal getAmount(Act act, String node) {
        BigDecimal value;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        BigDecimal result = BigDecimal.ZERO;
        if (bean.hasNode(node) && (value = bean.getBigDecimal(node)) != null) {
            result = this.addAmount(result, value, this.isCredit(bean));
        }
        return result;
    }

    public BigDecimal getTotal(FinancialAct act) {
        BigDecimal result = act.getTotal();
        if (result == null) {
            result = BigDecimal.ZERO;
        } else if (act.isCredit()) {
            result = result.negate();
        }
        return result;
    }

    public BigDecimal addAmount(BigDecimal total, BigDecimal amount, boolean isCredit) {
        BigDecimal result = isCredit ? total.subtract(amount) : total.add(amount);
        return this.round(result);
    }

    public boolean isCredit(Act act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return this.isCredit(bean);
    }

    private <T extends Act> BigDecimal sum(Collection<T> acts, String node) {
        return this.sum(acts.iterator(), node);
    }

    private boolean isCredit(IMObjectBean bean) {
        return bean.hasNode("credit") && bean.getBoolean("credit");
    }

    private BigDecimal round(BigDecimal amount) {
        if (this.scale != 0) {
            return MathRules.round(amount, this.scale);
        }
        return amount;
    }
}

