/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n;

import org.openvpms.component.i18n.Message;
import org.openvpms.component.i18n.Messages;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;

public class ArchetypeMessages {
    private static final Messages messages = new Messages("ARCH", ArchetypeMessages.class.getName());

    private ArchetypeMessages() {
    }

    public static Message priceCreatedByDelivery(Act delivery, Party supplier) {
        return messages.create(1501, new Object[]{delivery.getId(), supplier.getName(), delivery.getActivityStartTime()});
    }

    public static String passwordCannotContainWhitespace() {
        return messages.create(3000, new Object[0]).getMessage();
    }

    public static String passwordLessThanMinimumLength(int minLength) {
        return messages.create(3001, new Object[]{minLength}).getMessage();
    }

    public static String passwordGreaterThanMaximumLength(int maxLength) {
        return messages.create(3002, new Object[]{maxLength}).getMessage();
    }

    public static String passwordMustContainLowercaseCharacter() {
        return messages.create(3003, new Object[0]).getMessage();
    }

    public static String passwordMustContainUppercaseCharacter() {
        return messages.create(3004, new Object[0]).getMessage();
    }

    public static String passwordMustContainNumber() {
        return messages.create(3005, new Object[0]).getMessage();
    }

    public static String passwordMustContainSpecialCharacter() {
        return messages.create(3006, new Object[0]).getMessage();
    }

    public static String passwordCharacterInvalid(char character) {
        return messages.create(3007, new Object[]{Character.valueOf(character)}).getMessage();
    }

    public static String passwordCharacterInvalidSuffix() {
        return messages.create(3008, new Object[0]).getMessage();
    }

    public static String newPasswordMustBeDifferentToOldPassword() {
        return messages.create(3009, new Object[0]).getMessage();
    }
}

